/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.JaxbReflectionFieldInfo;
import com.ebmwebsourcing.easybox.impl.JaxbReflectionInfo;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.reflect.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public final class JaxbDuplicator {
    private final boolean allowTypeMorphing;
    private final IdentityHashMap<AbstractJaxbModelObject, AbstractJaxbModelObject> alreadyDuplicatedMap;

    private JaxbDuplicator(boolean allowTypeMorphing) {
        this.allowTypeMorphing = allowTypeMorphing;
        this.alreadyDuplicatedMap = new IdentityHashMap();
    }

    public static <T extends AbstractJaxbModelObject> T duplicate(T originalObject) {
        return (T)JaxbDuplicator.duplicateAs(originalObject, originalObject.getClass());
    }

    public static <T extends AbstractJaxbModelObject> T duplicateAs(AbstractJaxbModelObject originalObject, Class<T> targetClass) {
        JaxbDuplicator jaxbDuplicator = new JaxbDuplicator(true);
        return (T)jaxbDuplicator.doDuplicateModelObject(originalObject, targetClass);
    }

    private static boolean isImmutableObject(Object originalObject) {
        if (originalObject instanceof Number) {
            return true;
        }
        if (originalObject instanceof Boolean) {
            return true;
        }
        return originalObject instanceof Enum;
    }

    private Object doDuplicate(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        if (JaxbDuplicator.isImmutableObject(originalObject)) {
            return originalObject;
        }
        if (originalObject instanceof AbstractJaxbModelObject) {
            return this.doDuplicateModelObject((AbstractJaxbModelObject)originalObject);
        }
        if (originalObject instanceof List) {
            return this.doDuplicateList((List)originalObject);
        }
        if (originalObject instanceof Map) {
            return this.doDuplicateMap((Map)originalObject);
        }
        if (originalObject instanceof Set) {
            return this.doDuplicateSet((Set)originalObject);
        }
        if (originalObject instanceof JAXBElement) {
            return this.doDuplicateJAXBElement((JAXBElement)originalObject);
        }
        if (originalObject instanceof QName) {
            return this.doDuplicateQName((QName)originalObject);
        }
        if (originalObject instanceof String) {
            return this.doDuplicateString((String)originalObject);
        }
        if (originalObject instanceof Element) {
            Element originalElement = (Element)originalObject;
            Element clonedElement = (Element)originalElement.cloneNode(true);
            return clonedElement;
        }
        throw new UncheckedException(String.format("Cannot duplicate object of class '%s'.", originalObject.getClass().getSimpleName()));
    }

    private QName doDuplicateQName(QName originalObject) {
        return new QName(originalObject.getNamespaceURI(), originalObject.getLocalPart(), originalObject.getPrefix());
    }

    private String doDuplicateString(String originalObject) {
        return new String(originalObject);
    }

    private List<?> doDuplicateList(List<Object> originalObject) {
        List duplicateObject;
        try {
            duplicateObject = (List)ReflectionHelper.newInstance(originalObject.getClass(), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException("Cannot duplicate list.");
        }
        for (Object element : originalObject) {
            Object duplicateElement = this.doDuplicate(element);
            duplicateObject.add(duplicateElement);
        }
        return duplicateObject;
    }

    private Set<?> doDuplicateSet(Set<Object> originalObject) {
        Set duplicateObject;
        try {
            duplicateObject = (Set)ReflectionHelper.newInstance(originalObject.getClass(), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException("Cannot duplicate set.");
        }
        for (Object element : originalObject) {
            Object duplicateElement = this.doDuplicate(element);
            duplicateObject.add(duplicateElement);
        }
        return duplicateObject;
    }

    private Map<?, ?> doDuplicateMap(Map<Object, Object> originalObject) {
        Map duplicateObject;
        try {
            duplicateObject = (Map)ReflectionHelper.newInstance(originalObject.getClass(), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException("Cannot duplicate map.");
        }
        for (Map.Entry<Object, Object> entry : originalObject.entrySet()) {
            duplicateObject.put(this.doDuplicate(entry.getKey()), this.doDuplicate(entry.getValue()));
        }
        return duplicateObject;
    }

    private JAXBElement<?> doDuplicateJAXBElement(JAXBElement<?> originalObject) {
        if (originalObject == null) {
            return null;
        }
        JAXBElement<?> sourceElement = originalObject;
        Object sourceObject = sourceElement.getValue();
        Object copyObject = this.doDuplicate(sourceObject);
        JAXBElement copyElement = new JAXBElement(sourceElement.getName(), sourceElement.getDeclaredType(), sourceElement.getScope(), copyObject);
        return copyElement;
    }

    private AbstractJaxbModelObject doDuplicateModelObject(AbstractJaxbModelObject originalModelObject) {
        return this.doDuplicateModelObject(originalModelObject, originalModelObject.getClass());
    }

    private AbstractJaxbModelObject doDuplicateModelObject(AbstractJaxbModelObject originalModelObject, Class<? extends AbstractJaxbModelObject> targetClass) {
        JAXBElement<?> originalJAXBElement;
        AbstractJaxbModelObject duplicateModelObject;
        if (this.alreadyDuplicatedMap.containsKey(originalModelObject)) {
            return this.alreadyDuplicatedMap.get(originalModelObject);
        }
        Class<?> originalClass = originalModelObject.getClass();
        try {
            duplicateModelObject = (AbstractJaxbModelObject)ReflectionHelper.newInstance(targetClass, (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException(String.format("Cannot create new instance of class '%s' (InvocationTargetException).", targetClass.getSimpleName()), (Throwable)e);
        }
        this.alreadyDuplicatedMap.put(originalModelObject, duplicateModelObject);
        JaxbReflectionInfo reflectionInfo = JaxbReflectionInfo.getReflectionInfo(originalClass);
        for (JaxbReflectionFieldInfo fieldInfo : reflectionInfo.getFieldInfos()) {
            Object originalValue = ReflectionHelper.getFieldValue((Object)originalModelObject, (Field)fieldInfo.getField());
            Object duplicateValue = this.doDuplicate(originalValue);
            try {
                fieldInfo.getField().set(duplicateModelObject, duplicateValue);
            }
            catch (IllegalArgumentException e) {
                if (this.allowTypeMorphing) continue;
                throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (IllegalArgumentException).", fieldInfo.getField().getName(), targetClass.getSimpleName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (this.allowTypeMorphing) continue;
                throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (IllegalAccessException).", fieldInfo.getField().getName(), targetClass.getSimpleName()), (Throwable)e);
            }
        }
        duplicateModelObject.setXmlObject(null);
        String originalURIStr = String.valueOf(originalModelObject.getBaseURI());
        if (originalURIStr != null) {
            try {
                duplicateModelObject.setBaseURI(new URI(String.valueOf(originalURIStr)));
            }
            catch (URISyntaxException e) {
                throw new UncheckedException(String.format("Cannot duplicate URI '%s'.", originalURIStr));
            }
        }
        if ((originalJAXBElement = originalModelObject.getJAXBElement()) != null) {
            assert (originalJAXBElement.getValue() == originalModelObject);
            duplicateModelObject.setJaxbElement(this.doDuplicateJAXBElement(originalJAXBElement));
        }
        duplicateModelObject.setNaturalParent(null);
        duplicateModelObject.setAdoptiveParent(null);
        return duplicateModelObject;
    }
}

