package com.ebmwebsourcing.easybox.impl;

import java.net.URI;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ebmwebsourcing.easybox.api.ModelObject;

@XmlTransient
public abstract class AbstractJaxbModelObject extends AbstractModelObject {

    @XmlTransient
    private URI baseURI;

    @XmlTransient
    private Binder<Node> binder;

    @XmlTransient
    private JAXBElement<?> jaxbElement;

    @XmlTransient
    private Object naturalParent;

    @XmlTransient
    private Object adoptiveParent;

    public AbstractJaxbModelObject() {
        this.naturalParent = null;
        this.jaxbElement = null;
        this.baseURI = null;
        this.binder = null;
    }

    @Override
    public final int hashCode() {
        /*
         * TODO : hashCode generated by JAXB plugin is awfully expensive to
         * compute. this is much better to compute hashCode given this object
         * ancestors path and its base URI. For now, naive implementation is to
         * return a constant.
         */
        return 0;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null)
            return false;
        if (!(obj instanceof AbstractJaxbModelObject))
            return false;
        AbstractJaxbModelObject ajo = (AbstractJaxbModelObject) obj;
        if (getClass() != ajo.getClass()) {
            ajo = JaxbDuplicator.duplicateAs(ajo, this.getClass());
        }
        return ModelObjectComparator.areEquals(this, ajo);
    }

    @Override
    public URI getBaseURI() {
        AbstractJaxbModelObject current = this;
        URI uri = null;
        while (true) {
            if (current == null)
                break;
            uri = current.baseURI;
            if (uri != null)
                return uri;
            current = (AbstractJaxbModelObject) current.getNaturalParent();
        }
        return uri;
    }

    final Binder<Node> getBinder() {
        return binder;
    }

    final JAXBElement<?> getJAXBElement() {
        return this.jaxbElement;
    }

    String getOriginatingNamespaceURI() {
        return getClass().getPackage().getAnnotation(XmlSchema.class).namespace();
    }

    public final AbstractJaxbModelObject getNaturalParent() {
        if (naturalParent instanceof JAXBElement<?>) {
            return (AbstractJaxbModelObject) ((JAXBElement<?>) naturalParent).getValue();
        }
        return (AbstractJaxbModelObject) naturalParent;
    }


    
    public final AbstractJaxbModelObject getAdoptiveParent() {
        if (adoptiveParent instanceof JAXBElement<?>) {
            return (AbstractJaxbModelObject) ((JAXBElement<?>) adoptiveParent).getValue();
        }
        return (AbstractJaxbModelObject) adoptiveParent;
    }

    
    final QName getQName() {
        if (getClass().isAnnotationPresent(XmlRootElement.class)) {
            String namespaceURI = getOriginatingNamespaceURI();
            return new QName(namespaceURI, getClass().getAnnotation(
                    XmlRootElement.class).name());
        } else if (jaxbElement != null) {
            return jaxbElement.getName();
        } else if (binder != null) {
            Node node = binder.getXMLNode(this);
            assert node instanceof Element;
            if (node.getPrefix() == null) {
                return new QName(node.getNamespaceURI(), node.getLocalName());
            } else {
                return new QName(node.getNamespaceURI(), node.getLocalName(), node
                        .getPrefix());
            }
        } else {
            return JaxbReflector.guessQNameFromParent(this, getNaturalParent());
        }
    }

    @Override
    public void setBaseURI(URI baseUri) {
        this.baseURI = baseUri;
    }

    @Override
    public final Node getDOMNode() {
        return getBinder().getXMLNode(this);    
    }
    
    final void setBinder(Binder<Node> binder) {
        this.binder = binder;
        Node node = getDOMNode();
        assert node != null;
        node.setUserData("modelObject", this, null);
    }

    final void setJaxbElement(JAXBElement<?> jaxbElement) {
        this.jaxbElement = jaxbElement;
    }


    protected final void setNaturalParent(ModelObject naturalParent) {
        this.naturalParent = naturalParent;
    }

    protected final void setAdoptiveParent(ModelObject adoptiveParent) {
        this.adoptiveParent = adoptiveParent;
    }
    
    @Override
    public final ModelObject duplicate() {
        return JaxbDuplicator.duplicate(this);
    }

    
    @SuppressWarnings("unchecked")
    @Override
    public final <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        return (X) JaxbDuplicator.duplicateAs(this, (Class<? extends AbstractJaxbModelObject>) targetClass);
    }    

}
