/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.net.URI;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.jdom.Element;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Literal;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.PartnerLinkVar;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Query;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariableProperty;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TLiteral;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TQuery;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELElementExpressionImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class FromImpl extends BPELElementImpl<TFrom> implements From {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Kind kind;

	private Literal literal;

	private BPELExpression<Element> expression;

	private VariablePart variablePart;

	private VariableProperty variableProperty;

	private PartnerLinkVar partner;

	@SuppressWarnings("unchecked")
	public FromImpl(final TFrom model, final BPELElement parent) {
		super(Constants._From_QNAME, model, parent);


		// find literal
		for(final Object item: this.model.getContent()) {
			if ((item instanceof TLiteral)) {
				this.kind = Kind.LITERAL;
				this.literal = new LiteralImpl((TLiteral) item, this);
			} else if((item instanceof JAXBElement)&&(((JAXBElement)item).getValue() instanceof TLiteral)) {
				this.kind = Kind.LITERAL;
				this.literal = new LiteralImpl((TLiteral) ((JAXBElement)item).getValue(), this);
			}
		}


		if(this.model.getPartnerLink() != null) {
			// find partner
			this.kind = Kind.PARTNERLINK;

			this.partner = new PartnerLinkVarImpl(this.model.getPartnerLink(), this.model.getEndpointReference());

		} else if(this.model.getVariable() != null) {
			// find variable
			this.kind = Kind.VARIABLE_PART;

			// find query if exist
			Query query = null;

			for(final Object obj: this.model.getContent()) {
				if((obj instanceof JAXBElement)&&(((JAXBElement)obj).getValue() instanceof TQuery)) {
					final TQuery modelQ = (TQuery) ((JAXBElement)obj).getValue();
					query = new QueryImpl(modelQ, this);
				}
			}


			this.variablePart = new VariablePartImpl(new QName(this.model.getVariable()), this.model.getPart(), query);
		} else if(this.model.getProperty() != null) {

			this.variableProperty = new VariablePropertyImpl(this.model.getVariable(), this.model.getProperty());

		} else if((this.kind == null)&&(this.model.getContent().size() > 0)) {
			// find expression
			this.kind = Kind.EXPRESSION;
			final TExpression exp = new TExpression();
			exp.getContent().add(this.model.getContent().get(0));
			try {
				this.expression = new BPELElementExpressionImpl(exp, this, ScopeUtil.getProcess(this));
			} catch (XPathExpressionException e) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException(e)));
			}
		}
	}

	public Literal getLiteral() {
		return this.literal;
	}

	public void setLiteral(final Literal literal) {
		this.literal = literal;
	}

	public BPELExpression<Element> getExpressionDefinition() {
		return this.expression;
	}

	public Kind getKind() {
		return this.kind;
	}

	public VariablePart getVariablePart() {
		return this.variablePart;
	}

	public VariableProperty getVariableProperty() {
		return this.variableProperty; 
	}

	public void setExpressionDefinition(final BPELExpression<Element> exp) {
		this.expression = exp;
		this.model.getContent().clear();
		if(((TExpression)((AbstractSchemaElementImpl)this.expression).getModel()).getContent().size() > 0)
		this.model.getContent().add(((TExpression)((AbstractSchemaElementImpl)this.expression).getModel()).getContent().get(0));
	}

	public void setKind(final Kind kind) {
		this.kind = kind;
	}

	public void setVariablePart(final VariablePart vp) {
		this.variablePart = vp; 
	}

	public void setVariableProperty(final VariableProperty vp) {
		this.variableProperty = vp;
	}

	@Override
	public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
		return null;
	}

	public String getContent() {
		String res = null;
		if(this.expression != null) {
			res = this.expression.getContent();
		} 
		return res;
	}

	public void setContent(final String content) {
		if(this.expression != null) {
		this.expression.setContent(content);
		} else {
			final TExpression exp = new TExpression();
			exp.getContent().add(content);
			try {
				this.setExpressionDefinition(new BPELElementExpressionImpl(exp, this, ScopeUtil.getProcess(this)));
			} catch (XPathExpressionException e) {
				// do nothing
			}
		}
		
	}

	public PartnerLinkVar getPartnerLinkVar() {
		return this.partner;
	}

	public void setPartnerLinkVar(final PartnerLinkVar partner) {
		this.partner = partner;
	}


	@Override
	public String toString() {
		String res = null;
		if(this.model != null) {
			if(this.getContent() != null) {
				res = this.getContent();
			} else if(this.getVariablePart() != null) {
				res = this.getVariablePart().toString();
			} else if(this.getPartnerLinkVar() != null) {
				res = this.getPartnerLinkVar().toString();
			} else if(this.getLiteral() != null) {
				res = this.getLiteral().toString();
			} 
		}
		return res;
	}

	public org.jdom.Element evaluate(final Scope scope) throws CoreException {
		return null;
	}

	public URI getExpressionLanguage() {
		URI res = null;
		if(this.expression != null) {
			res = this.expression.getExpressionLanguage();
		}
		return res;
	}

	public void setExpressionLanguage(final URI language) {
		this.model.setExpressionLanguage(language.toString());
		if(this.expression != null) {
			this.expression.setExpressionLanguage(language);
		} else {
			final TExpression exp = new TExpression();
			exp.setExpressionLanguage(language.toString());
			try {
				this.setExpressionDefinition(new BPELElementExpressionImpl(exp, this, ScopeUtil.getProcess(this)));
			} catch (XPathExpressionException e) {
				// do nothing
			}
		}
	}

	public Expression<String, org.jdom.Element> copypaste() {
		final From from = new FromImpl(this.getModel(), (BPELElementImpl) this.getParent());
		return from;
	}
}
