/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.message;

import org.jdom.Element;

import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.IdenticalMessageConverterImpl;

public class DefaultBPELMessageConverter extends IdenticalMessageConverterImpl<BPELExternalMessageImpl, BPELInternalMessageImpl, Element> {

	
	public static MessageConverter<BPELExternalMessageImpl, BPELInternalMessageImpl> get() {
		// create internal message type
		final BPELInternalMessageImpl internalMessage = new BPELInternalMessageImpl();

		// create external message type
		final BPELExternalMessageImpl externalMessage = new BPELExternalMessageImpl();

		// create message converter
		final MessageConverter<BPELExternalMessageImpl, BPELInternalMessageImpl> converter = new IdenticalMessageConverterImpl<BPELExternalMessageImpl, BPELInternalMessageImpl, Element>(externalMessage.getClass(), internalMessage.getClass());

		return converter;
	}
	
	public DefaultBPELMessageConverter(final Class<? extends ExternalMessage> externalMsg,
			final Class<? extends InternalMessage> internalMsg) {
		super(externalMsg, internalMsg);
	}
	
}
