/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Description;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Property;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PropertyAlias;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.DescriptionImpl;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Include;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.decorator.DecoratorDescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.tools.MyListOfEndpoints;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DescriptionsImpl implements com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	String processNamespace;
	String processItfName;

	List<Import> imports = new ArrayList<Import>();
	List<Description> descriptions = new ArrayList<Description>();

	List<Schema> schemas = new ArrayList<Schema>();
	public void setSchemas(List<Schema> schemas) {
		this.schemas = schemas;
	}

	List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();

	NamespaceMapperImpl namespaces = null;

	List<PartnerLinkType> partnerLinkTypes = null;
	List<Property> properties = null;
	List<PropertyAlias> propertyAliases = null;
	List<InterfaceType> interfaces = null;
	List<Binding> bindings = null;
	List<Service> services = null;
	List<MessageImpl> messages = null;

	public DescriptionsImpl(final String processNamespace, final String processItfName, final List<Import> imports) {
		this.processNamespace = processNamespace;
		this.processItfName = processItfName;
		this.imports = imports;

		for(final Import impt: this.imports) {
			if(impt.getDescription() != null) {
				this.descriptions.add(impt.getDescription());
			} else if(impt.getSchema() != null) {
				this.schemas.add(impt.getSchema());
			}
		}
	}
	
	public List<Description> getDescriptions() {
		return descriptions;
	}

	public List<Import> getBPELImports() {
		return this.imports;
	}

	public void setPartnerLink(final List<PartnerLink> pls) {
		this.partnerLinks = pls;
	}

	public List<Schema> getSchemas() {
		return this.schemas;
	}

	public void addPartnerLinkType(final PartnerLinkType arg0)
	throws WSDL4BPELException {
		throw new NotImplementedException();
	}


	public List<PartnerLinkType> getPartnerLinkTypes()
	throws WSDL4BPELException {
		if(this.partnerLinkTypes == null) {
			this.partnerLinkTypes = new ArrayList<PartnerLinkType>();

			for(final Description desc: this.descriptions) {
				this.partnerLinkTypes.addAll(desc.getPartnerLinkTypes());
			}
		}
		return this.partnerLinkTypes;
	}


	public List<PartnerLinkType> removeAllPartnerLinkTypes()
	throws WSDL4BPELException {
		throw new NotImplementedException();
	}


	public PartnerLinkType removePartnerLinkType(final PartnerLinkType arg0)
	throws WSDL4BPELException {
		throw new NotImplementedException();
	}


	public void addBinding(final Binding binding) {
		throw new NotImplementedException();
	}


	public void addImport(final Import importDef) {
		throw new NotImplementedException();
	}


	public void addInclude(final Include includeDef) throws WSDLException {
		throw new NotImplementedException();
	}


	public void addInterface(final InterfaceType interfaceType) {
		throw new NotImplementedException();
	}


	public void addNamespace(final String prefix, final String namespaceURI) {
		throw new NotImplementedException();
	}


	public void addService(final Service service) {
		throw new NotImplementedException();
	}


	public Binding createBinding() {
		throw new NotImplementedException();
	}


	public org.ow2.easywsdl.wsdl.api.Import createImport() {
		throw new NotImplementedException();
	}


	public InterfaceType createInterface() {
		throw new NotImplementedException();
	}


	public Service createService() {
		throw new NotImplementedException();
	}


	public Types createTypes() {
		throw new NotImplementedException();
	}


	public Binding getBinding(final QName name) {
		Binding res = null;

		for(final Description desc: this.descriptions) {
			res = desc.getBinding(name);
			if(res != null) {
				break;
			}
		}
		return res;
	}


	public List<Binding> getBindings() {
		if(this.bindings == null) {
			this.bindings = new ArrayList<Binding>();

			for(final Description desc: this.descriptions) {
				this.bindings.addAll(desc.getBindings());
			}
		}
		return this.bindings;
	}


	public URI getDocumentBaseURI() {
		return null;
	}


	public List<org.ow2.easywsdl.wsdl.api.Import> getImports() {
		return null;
	}


	public List<org.ow2.easywsdl.wsdl.api.Import> getImports(final String namespaceURI) {
		// TODO Auto-generated method stub
		return null;
	}


	public List<Include> getIncludes() {
		// TODO Auto-generated method stub
		return null;
	}


	public List<Include> getIncludes(final String locationURI) {
		// TODO Auto-generated method stub
		return null;
	}


	public InterfaceType getInterface(final QName name) {
		InterfaceType res = null;

		for(final Description desc: this.descriptions) {
			res = desc.getInterface(name);
			if(res != null) {
				break;
			}
		}
		return res;
	}


	public List<InterfaceType> getInterfaces() {
		if(this.interfaces == null) {
			this.interfaces = new ArrayList<InterfaceType>();

			for(final Description desc: this.descriptions) {
				this.interfaces.addAll(desc.getInterfaces());
			}
		}
		return this.interfaces;
	}


	public MessageImpl getMessage(final QName name) {
		MessageImpl res = null;

		if(this.messages == null) {
			this.messages = this.getMessages();
		}

		for(final MessageImpl msg: this.messages) {
			if(msg.getQName().equals(name)) {
				res = msg;
				break;
			}
		}

		return res;
	}

	public List<MessageImpl> getMessages() {
		final List<MessageImpl> res = new ArrayList<MessageImpl>();
		for(final Description desc: this.descriptions) {
			res.addAll(this.getMessages(desc));
		}
		return res;
	}	

	private List<MessageImpl> getMessages(final AbsItfDescription desc) {
		final List<MessageImpl> res = new ArrayList<MessageImpl>();
		if(desc instanceof DescriptionImpl) {
			if((((DecoratorDescriptionImpl)desc).getInternalObject() instanceof org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl)) {
				final org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl wsdl11 = (org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl) ((DecoratorDescriptionImpl)desc).getInternalObject();
				res.addAll(wsdl11.getMessages());
			}
		}
		if(res == null) {
			for(final org.ow2.easywsdl.wsdl.api.Import impt: (List<org.ow2.easywsdl.wsdl.api.Import>)desc.getImports()) {
				res.addAll(this.getMessages(impt.getDescription()));
			}
		}
		return res;
	}


	public MessageImpl findMessage(final QName name, final AbsItfDescription desc) {

		MessageImpl res = null;
		if(desc instanceof DescriptionImpl) {
			if((((DecoratorDescriptionImpl)desc).getInternalObject() instanceof org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl)) {
				final org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl wsdl11 = (org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl) ((DecoratorDescriptionImpl)desc).getInternalObject();
				res = wsdl11.getMessage(name);
			}
		}

		if(res == null) {
			for(final org.ow2.easywsdl.wsdl.api.Import impt: (List<org.ow2.easywsdl.wsdl.api.Import>)desc.getImports()) {
				res =  this.findMessage(name, impt.getDescription());
			}
		}

		return res;
	}


	public NamespaceMapperImpl getNamespaces() {
		if( this.namespaces == null ) {
			this.namespaces = new NamespaceMapperImpl();
		}
		for(final Description desc : this.descriptions) {
			for(final Entry<String, String> ns: (desc.getNamespaces()).getNamespaces().entrySet()) {
				(this.namespaces).addNamespace(ns.getKey(), ns.getValue());
			}
		}
		return this.namespaces;
	}


	public QName getQName() throws WSDLException {
		return null;
	}


	public Map<String, String> getSchemaLocation() {
		throw new NotImplementedException();
	}


	public Service getService(final QName name) {
		Service res = null;

		for(final Description desc: this.descriptions) {
			res = desc.getService(name);
			if(res != null) {
				break;
			}
		}
		return res;
	}


	public List<Service> getServices() {
		if(this.services == null) {
			this.services = new ArrayList<Service>();

			for(final Description desc: this.descriptions) {
				this.services.addAll(desc.getServices());
			}
		}
		return this.services;
	}


	public String getTargetNamespace() {
		return null;
	}


	public Types getTypes() {
		// TODO Auto-generated method stub
		return null;
	}


	public WSDLVersionConstants getVersion() {
		return null;
	}


	public Binding removeBinding(final QName name) {
		throw new NotImplementedException();
	}


	public Import removeImport(final Import importDef) {
		throw new NotImplementedException();
	}


	public Include removeInclude(final Include includeDef) throws WSDLException {
		throw new NotImplementedException();
	}


	public InterfaceType removeInterface(final QName name) {
		throw new NotImplementedException();
	}


	public String removeNamespace(final String prefix) {
		throw new NotImplementedException();
	}


	public Service removeService(final QName name) {
		throw new NotImplementedException();
	}


	public void setDocumentBaseURI(final URI documentBaseURI) {
		throw new NotImplementedException();
	}


	public void setQName(final QName name) throws WSDLException {
		throw new NotImplementedException();
	}


	public void setTargetNamespace(final String targetNamespace) {
		throw new NotImplementedException();
	}


	public void setTypes(final Types types) {
		throw new NotImplementedException();
	}


	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}


	public Documentation createDocumentation() {
		throw new NotImplementedException();
	}


	public Documentation getDocumentation() {
		throw new NotImplementedException();
	}


	public Map<QName, String> getOtherAttributes() throws XmlException {
		throw new NotImplementedException();
	}


	public void setDocumentation(final Documentation arg0) {
		throw new NotImplementedException();
	}

	public void addImport(final org.ow2.easywsdl.wsdl.api.Import importDef) {
		throw new NotImplementedException();
	}

	public org.ow2.easywsdl.wsdl.api.Import removeImport(
			final org.ow2.easywsdl.wsdl.api.Import importDef) {
		throw new NotImplementedException();
	}

	public Binding createDefaultSoapBinding(final String bindingName,
			final Endpoint endpoint, final InterfaceType itf) {
		return null;
	}

	public List<Endpoint> findEndpointsImplementingInterface(final InterfaceType itf) {
		final MyListOfEndpoints res = new MyListOfEndpoints();
		for(final Description desc: this.descriptions) {
			List<Endpoint> endpointsList = desc.findEndpointsImplementingInterface(itf);
			java.util.Iterator<Endpoint> itEndpoints = endpointsList.iterator();
			while(itEndpoints.hasNext()){
				Endpoint e = itEndpoints.next();
				if(!res.containsEndpoint(e)){
					res.add(e);
				}
			}
		}
		return res;
	}

	public Endpoint findEndpoint(final String endpointName) {
		Endpoint res = null;
		for(final Description desc: this.descriptions) {
			for(final Service s: desc.getServices()) {
				for(final Endpoint ep: s.getEndpoints()) {
					if(ep.getName().equals(endpointName)) {
						res = ep;
						break;
					}
				}
				if(res != null) {
					break;
				}
			}
			if(res != null) {
				break;
			}
		}
		return res;
	}

	public PartnerLinkType getPartnerLinkType(final QName plt) throws WSDL4BPELException {
		PartnerLinkType res = null;
		for(final PartnerLinkType partner: this.getPartnerLinkTypes()) {
			if(partner.getQName().equals(plt)) {
				res = partner;
				break;
			}
		}
		return res;
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

	public List<AbsItfInterfaceType> getProcessInterfaces() throws WSDL4BPELException {
		final List<AbsItfInterfaceType> res = new ArrayList<AbsItfInterfaceType>();
		if(this.partnerLinks != null) {
			for(final PartnerLink pl : this.partnerLinks) {
				if((pl.getMyRole() != null) && (pl.getMyRole().trim().length() > 0)) {
					if(pl.getPartnerLinkType() != null) {
						final PartnerLinkType plt = this.getPartnerLinkType(pl.getPartnerLinkType());
						if(plt != null) {
							final Role role = plt.getRole(pl.getMyRole());
							final InterfaceType itf = role.getInterface();
							if(itf != null) {
								res.add(itf);
							}
						}
					}
				}
			}
		}
		return res;
	}

	public AbsItfDescription getDescriptionByInterface(final QName itfName) {
		AbsItfDescription res = null;
		final InterfaceType itf = this.getInterface(itfName);
		if(itf != null) {
			res = (AbsItfDescription) ((AbstractWSDLElementImpl)itf).getTopParent(); 
		}
		return res;

	}

	public AbsItfDescription getDescriptionByService(final QName serviceName) {
		AbsItfDescription res = null;
		final Service serv = this.getService(serviceName);
		if(serv != null) {
			res = (AbsItfDescription) ((AbstractWSDLElementImpl)serv).getTopParent(); 
		}
		return res;
	}

	public AbsItfDescription getDescriptionByProperty(final QName propertyName) throws WSDL4BPELException {
		AbsItfDescription res = null;
		final Property prop = this.getProperty(propertyName);
		if(prop != null) {
			res = (AbsItfDescription) ((AbstractWSDLElementImpl)prop).getTopParent(); 
		}
		return res;
	}

	public URI getDocumentURI() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setDocumentURI(final URI arg0) {
		// TODO Auto-generated method stub

	}

	public String getDocumentBaseURIString() {
		// TODO Auto-generated method stub
		return null;
	}


	public List<org.ow2.easywsdl.schema.api.Element> findElementsInAllSchema(final QName element) {
		final List<org.ow2.easywsdl.schema.api.Element> res = new ArrayList<org.ow2.easywsdl.schema.api.Element>();
		for(final Schema schema: this.schemas) {
			res.addAll(schema.findElementsInAllSchema(element));
		}

		for(final Description desc: this.descriptions) {
			res.addAll(this.findElementsInAllSchema(desc, element));
		}
		return res;
	}

	private Collection<? extends org.ow2.easywsdl.schema.api.Element> findElementsInAllSchema(
			final AbsItfDescription desc, final QName element) {
		final List<org.ow2.easywsdl.schema.api.Element> res = new ArrayList<org.ow2.easywsdl.schema.api.Element>();
		if(desc.getTypes() != null) {
			for(final AbsItfSchema schema: (List<AbsItfSchema>)desc.getTypes().getSchemas()) {
				res.addAll(schema.findElementsInAllSchema(element));
			}
		}
		for(final AbsItfImport impt: (List<AbsItfImport>)desc.getImports()) {
				res.addAll(this.findElementsInAllSchema(impt.getDescription(), element));
		}
		return res;
	}

	public List<org.ow2.easywsdl.schema.api.Type> findTypesInAllSchema(final QName type) {
		final List<org.ow2.easywsdl.schema.api.Type> res = new ArrayList<org.ow2.easywsdl.schema.api.Type>();
		org.ow2.easywsdl.schema.api.Type item = null;
		for(final Schema schema: this.schemas) {
			item = schema.getType(type);
			if(item != null) {
				res.add(item);
			}
		}
		for(final Description desc: this.descriptions) {
			for(final Schema schema: desc.getTypes().getSchemas()) {
				item = schema.getType(type);
				if(item != null) {
					res.add(item);
				}
			}
		}
		return res;
	}

	public List<Property> getProperties() throws WSDL4BPELException {
		if(this.properties == null) {
			this.properties = new ArrayList<Property>();

			for(final Description desc: this.descriptions) {
				this.properties.addAll(desc.getProperties());
			}
		}
		return this.properties;
	}

	public List<PropertyAlias> getAllPropertyAliases() throws WSDL4BPELException {
		if(this.propertyAliases == null) {
			this.propertyAliases = new ArrayList<PropertyAlias>();

			for(final Description desc: this.descriptions) {
				this.propertyAliases.addAll(desc.getAllPropertyAliases());
			}
		}
		return this.propertyAliases;
	}


	public Property getProperty(final QName propName) throws WSDL4BPELException {
		Property res = null;
		for(final Property prop: this.getProperties()) {
			if(prop.getQName().equals(propName)) {
				res = prop;
				break;
			}
		}
		return res;
	}

	public List<PropertyAlias> getPropertyAliases4ThisProperty(final QName propName)
	throws WSDL4BPELException {
		final List<PropertyAlias> res = new ArrayList<PropertyAlias>();
		for(final PropertyAlias prop: this.getAllPropertyAliases()) {
			if(prop.getPropertyName().equals(propName)) {
				res.add(prop);
			}
		}
		return res;
	}

	public Include getInclude(final URI arg0) {
		//TODO
		throw new UnsupportedOperationException("Not supported yet.");
	}


}
