/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageAdapter;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractOperationImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPAdapter
implements MessageAdapter {
    private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private Endpoint providerEndpoint;
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";

    public SOAPAdapter(BPELProcess bPELProcess, Endpoint endpoint) {
        this.desc = bPELProcess.getImports();
        this.bpeldefinition = bPELProcess;
        this.providerEndpoint = endpoint;
    }

    public SOAPAdapter(BPELProcess bPELProcess) {
        this.desc = bPELProcess.getImports();
        this.bpeldefinition = bPELProcess;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public InternalMessage<?> adapt(InternalMessage<?> internalMessage) throws CoreException {
        BPELInternalMessage bPELInternalMessage = null;
        if (this.providerEndpoint == null) {
            throw new CoreException("Provider Endpoint cannot be null");
        }
        bPELInternalMessage = this.format((BPELInternalMessage)internalMessage, this.providerEndpoint);
        return bPELInternalMessage;
    }

    private BPELInternalMessage format(BPELInternalMessage bPELInternalMessage, Endpoint endpoint) throws CoreException {
        BPELInternalMessage bPELInternalMessage2 = bPELInternalMessage;
        this.log.finest("providerEndpoint.getEndpointName() = " + endpoint.getEndpointName());
        this.log.finest("providerEndpoint.getInterfaceName() = " + endpoint.getInterfaceName());
        this.log.finest("providerEndpoint.getServiceName() = " + endpoint.getServiceName());
        this.log.finest("providerEndpoint.getDescription() = " + endpoint.getDescription());
        if (bPELInternalMessage != null && endpoint.getDescription() != null) {
            Operation operation = null;
            InterfaceType interfaceType = (InterfaceType)this.desc.getInterface(endpoint.getInterfaceName());
            operation = (Operation)interfaceType.getOperation(new QName(interfaceType.getQName().getNamespaceURI(), endpoint.getInvokedOperation()));
            if (operation != null) {
                Object object2;
                Binding binding = null;
                for (Object object2 : this.desc.getBindings()) {
                    if (object2.getInterface() == null || !((InterfaceType)object2.getInterface()).getQName().equals(interfaceType.getQName())) continue;
                    binding = object2;
                    break;
                }
                if (binding == null) {
                    throw new CoreException("Impossible to find binding corresponding to interface: " + interfaceType.getQName());
                }
                object2 = null;
                for (Object object3 : binding.getBindingOperations()) {
                    if (!object3.getQName().getLocalPart().equals(operation.getQName().getLocalPart())) continue;
                    object2 = object3;
                }
                if (object2 != null) {
                    Object object3;
                    object3 = REQUEST;
                    if (endpoint.getEndpointName() != null && endpoint.getEndpointName().equals("client")) {
                        object3 = RESPONSE;
                    }
                    if (object2.getStyle() == AbsItfBinding.StyleConstant.DOCUMENT) {
                        this.log.finest("format as document");
                        bPELInternalMessage2 = this.formatAsDocument(bPELInternalMessage, operation, (String)object3);
                    } else if (object2.getStyle() == AbsItfBinding.StyleConstant.RPC) {
                        this.log.finest("format as rpc");
                        bPELInternalMessage2 = this.formatAsRpc(bPELInternalMessage, (BindingOperation)object2, operation, (String)object3);
                    }
                }
            }
            bPELInternalMessage2.setQName(new QName(((Element)bPELInternalMessage.getContent()).getNamespaceURI(), ((Element)bPELInternalMessage.getContent()).getName()));
        }
        return bPELInternalMessage2;
    }

    private BPELInternalMessage formatAsRpc(BPELInternalMessage bPELInternalMessage, BindingOperation bindingOperation, Operation operation, String string) {
        BPELInternalMessageImpl bPELInternalMessageImpl = new BPELInternalMessageImpl();
        if (bPELInternalMessage != null) {
            bPELInternalMessageImpl.setEndpoint(bPELInternalMessage.getEndpoint());
            bPELInternalMessageImpl.setQName(bPELInternalMessage.getQName());
            bPELInternalMessageImpl.setService(bPELInternalMessage.getService());
            Element element = (Element)((Element)bPELInternalMessage.getContent()).clone();
            String string2 = bindingOperation.getQName().getLocalPart();
            if (string.equals(RESPONSE)) {
                string2 = String.valueOf(string2) + "Response";
            }
            element.setName(string2);
            if (!element.getNamespaceURI().equals(bindingOperation.getQName().getNamespaceURI())) {
                element.setNamespace(Namespace.getNamespace((String)bindingOperation.getQName().getNamespaceURI()));
            }
            Document document = new Document(element);
            bPELInternalMessageImpl.setContent(document.getRootElement());
        } else {
            String string3 = bindingOperation.getQName().getLocalPart();
            if (string.equals(RESPONSE)) {
                string3 = String.valueOf(string3) + "Response";
            }
            Element element = new Element(string3, bindingOperation.getQName().getNamespaceURI());
            Document document = new Document(element);
            bPELInternalMessageImpl.setContent(document.getRootElement());
        }
        return bPELInternalMessageImpl;
    }

    private BPELInternalMessage formatAsDocument(BPELInternalMessage bPELInternalMessage, Operation operation, String string) {
        BPELInternalMessageImpl bPELInternalMessageImpl = new BPELInternalMessageImpl();
        if (bPELInternalMessage != null) {
            String string2;
            bPELInternalMessageImpl.setEndpoint(bPELInternalMessage.getEndpoint());
            bPELInternalMessageImpl.setQName(bPELInternalMessage.getQName());
            bPELInternalMessageImpl.setService(bPELInternalMessage.getService());
            Element element = null;
            element = ((Element)bPELInternalMessage.getContent()).getChildren() != null && ((Element)bPELInternalMessage.getContent()).getChildren().size() == 1 && (((Input)operation.getInput()).getMessageName().getLocalPart().equals(((Element)bPELInternalMessage.getContent()).getName()) || operation.getOutput() != null && ((Output)operation.getOutput()).getMessageName().getLocalPart().equals(((Element)bPELInternalMessage.getContent()).getName())) ? (Element)((Element)((Element)bPELInternalMessage.getContent()).getChildren().get(0)).clone() : (Element)((Element)bPELInternalMessage.getContent()).clone();
            if (string.equals(REQUEST) && operation.getInput() != null && ((Input)operation.getInput()).getParts() != null && ((Part)((Input)operation.getInput()).getParts().get(0)).getType() != null && ((Part)((Input)operation.getInput()).getParts().get(0)).getPartQName() != null) {
                element.setName(((Part)((Input)operation.getInput()).getParts().get(0)).getPartQName().getLocalPart());
            }
            if (element.getNamespaceURI() == null || element.getNamespaceURI().trim().length() == 0) {
                string2 = null;
                string2 = ((AbstractInterfaceTypeImpl)((AbstractOperationImpl)operation).getInterface()).getDescription().getNamespaces().getPrefix(operation.getQName().getNamespaceURI());
                if (string2 == null || string2.trim().length() == 0) {
                    for (Namespace namespace : element.getAdditionalNamespaces()) {
                        if (!namespace.getURI().equals(operation.getQName().getNamespaceURI())) continue;
                        string2 = namespace.getPrefix();
                        break;
                    }
                }
                if (string2 != null) {
                    element.setNamespace(Namespace.getNamespace((String)string2, (String)operation.getQName().getNamespaceURI()));
                } else {
                    element.setNamespace(Namespace.getNamespace((String)operation.getQName().getNamespaceURI()));
                }
            }
            if (((Input)operation.getInput()).getParts() != null && ((Part)((Input)operation.getInput()).getParts().get(0)).getType() != null) {
                element.setNamespace(null);
            }
            string2 = new Document(element);
            bPELInternalMessageImpl.setContent(string2.getRootElement());
        } else {
            Element element = null;
            if (string.equals(REQUEST)) {
                if (operation.getInput() != null) {
                    if (((Input)operation.getInput()).getElement() != null) {
                        element = new Element(((Input)operation.getInput()).getElement().getQName().getLocalPart(), ((Input)operation.getInput()).getElement().getQName().getNamespaceURI());
                    } else if (((Input)operation.getInput()).getName() != null) {
                        element = new Element(((Input)operation.getInput()).getName(), operation.getQName().getNamespaceURI());
                    }
                }
            } else if (operation.getOutput() != null) {
                if (((Output)operation.getOutput()).getElement() != null) {
                    element = new Element(((Output)operation.getOutput()).getElement().getQName().getLocalPart(), ((Output)operation.getOutput()).getElement().getQName().getNamespaceURI());
                } else if (((Output)operation.getOutput()).getName() != null) {
                    element = new Element(((Output)operation.getOutput()).getName(), operation.getQName().getNamespaceURI());
                }
            }
            if (element != null) {
                Document document = new Document(element);
                bPELInternalMessageImpl.setContent(document.getRootElement());
            }
        }
        return bPELInternalMessageImpl;
    }

    public InternalMessage<?> formatFault(InternalMessage<?> internalMessage) {
        BPELInternalMessageImpl bPELInternalMessageImpl = new BPELInternalMessageImpl();
        bPELInternalMessageImpl.setContent(Util.getChildElements((Element)internalMessage.getContent()).get(0));
        bPELInternalMessageImpl.setEndpoint(internalMessage.getEndpoint());
        bPELInternalMessageImpl.setOperationName(internalMessage.getOperationName());
        bPELInternalMessageImpl.setQName(internalMessage.getQName());
        bPELInternalMessageImpl.setService(internalMessage.getService());
        return bPELInternalMessageImpl;
    }

    public Element getDetails(Element element) {
        Element element2 = null;
        element2 = element.getChild("detail", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/"));
        if (element2 == null) {
            element2 = element.getChild("detail");
        }
        if (element2 == null) {
            element2 = element.getChild("Detail", Namespace.getNamespace((String)"http://www.w3.org/2003/05/soap-envelope"));
        }
        if (element2 == null) {
            element2 = element.getChild("Detail");
        }
        return element2;
    }

    public Element createSOAPFault(Element element) {
        Element element2 = null;
        element2 = new Element("Fault", Namespace.getNamespace((String)"soap", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        Document document = new Document(element2);
        Element element3 = new Element("faultcode");
        element3.setText("soap:Server");
        element2.addContent((Content)element3);
        Element element4 = new Element("detail");
        if (element != null) {
            element4.addContent((Content)((Element)element.clone()));
        }
        element2.addContent((Content)element4);
        return document.getRootElement();
    }
}

