/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.extension;

import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtension;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extension;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;

public class ExtensionImpl extends BPELElementImpl<TExtension> implements Extension {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;



	public ExtensionImpl(final TExtension model, final BPELElement parent) {
		super(Constants._Extension_QNAME, model, parent);
	}



	public Boolean getMustUnderstand() {
		Boolean res = null;
		if(this.model.getMustUnderstand() != null) {
			if(this.model.getMustUnderstand().equals(TBoolean.YES) ) {
				res = true;
			} else {
				res = false;
			}
		}
		return res;
	}



	public String getNameSpace() {
		return this.model.getNamespace();
	}

}
