/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.ExternalMessageImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELExternalMessageImpl extends ExternalMessageImpl<Element> implements
ExternalMessage<Element>, BPELExternalMessage {

	public void setMessage(final String msg) throws BPELException {
		try {
			final SAXBuilder parser = new SAXBuilder();
			final Document doc = parser.build(new ByteArrayInputStream(msg.getBytes()));
			this.setContent(doc.getRootElement());
		} catch (final JDOMException e) {
			throw new BPELException(e);
		} catch (final IOException e) {
			throw new BPELException(e);
		}

	}


	@Override
	public String toString() {
		String res = null;
		if(this.getContent() != null) {
			final XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
			res = outputter.outputString(this.getContent());
		} else {
			res = super.toString();
		}

		return res; 
	}
}
