/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.input.DOMBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.ServiceRef;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELWriterImpl;
import com.ebmwebsourcing.easybpel.model.bpel.serviceref.ObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.serviceref.ServiceRefType;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ServiceRefImpl extends BPELElementImpl<ServiceRefType> implements ServiceRef {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(ServiceRefImpl.class.getName());

	private EndpointReferenceType epr;

	private final ObjectFactory factory = new ObjectFactory();
	
	private static WSAddressingReader reader = null;
	private static WSAddressingException readerEx = null;

	
	
	static {
		try {
			reader = WSAddressingFactory.getInstance().newWSAddressingReader();
		} catch (final WSAddressingException e) {
			readerEx = e;
		}
	}
	
	
	public WSAddressingReader getReader() throws WSAddressingException {
		if(readerEx != null) {
			throw readerEx;
		}
		return reader;
	}


	public ServiceRefImpl(final ServiceRefType model, final BPELElementImpl parent) {
		super(Constants._ServiceRef_QNAME, model, parent);

		try {
			if(this.model.getAny() instanceof Element) {
				this.epr = this.getReader().readEndpointReferenceType(((Element)this.model.getAny()).getOwnerDocument());
			} else if((this.model.getAny() instanceof JAXBElement)&&
					(((JAXBElement)this.model.getAny()).getValue() instanceof com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType)) {
				this.epr = new EndpointReferenceTypeImpl(new URI("."), (com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType) ((JAXBElement)this.model.getAny()).getValue(), null);
			} else if(this.model.getAny() instanceof com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType) {
				this.epr = new EndpointReferenceTypeImpl(new URI("."), (com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType) this.model.getAny(), null);
			} 
		} catch (final WSAddressingException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In one serviceRef => " + e.getMessage(), e)));
		} catch (final URISyntaxException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In one serviceRef => " + e.getMessage(), e)));
		}
	}


	public EndpointReferenceType getEpr() {
		return this.epr;
	}
	
	public org.jdom.Element toElement() {
		org.jdom.Element res = null;
		try {
			final Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			new BPELWriterImpl().getJaxbContext().createMarshaller().marshal(this.factory.createServiceRef(this.model), doc);
			final DOMBuilder builder = new DOMBuilder();
			final org.jdom.Document jdomDocument = builder.build(doc);
			res = jdomDocument.getRootElement();
		} catch (final ParserConfigurationException e) {
			e.printStackTrace();
			// do nothing
			log.warning(e.getMessage());
		} catch (final BPELException e) {
			e.printStackTrace();
			// do nothing
			log.warning(e.getMessage());
		} catch (final JAXBException e) {
			e.printStackTrace();
			// do nothing
			log.warning(e.getMessage());
		}
		return res;
	}

	@Override
	public String toString() {
		String res = null;
		try {
			final Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
//			Document docEpr = WSAddressingFactory.newInstance().newWSAddressingWriter().getDocument(this.getEpr());
//			Element sref = doc.createElementNS("http://docs.oasis-open.org/wsbpel/2.0/serviceref", "service-ref");
//			sref.setPrefix("s-ref");
//			doc.appendChild(sref);
//			sref.appendChild(doc.adoptNode(docEpr.getDocumentElement()));
			
			new BPELWriterImpl().getJaxbContext().createMarshaller().marshal(this.factory.createServiceRef(this.model), doc);
			res = XMLPrettyPrinter.prettyPrint(doc);
		} catch (final ParserConfigurationException e) {
			e.printStackTrace();
			// do nothing
			log.warning(e.getMessage());
		} catch (final BPELException e) {
			e.printStackTrace();
			// do nothing
			log.warning(e.getMessage());
		} catch (final JAXBException e) {
			e.printStackTrace();
			// do nothing
			log.warning(e.getMessage());
		}
		return res;
	}
	
}
