/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ReThrow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Literal;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Query;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELError;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELInfo;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELWarning;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extension;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extensions;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELWarningImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.AssignValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CatchValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CopyValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CorrelationSetValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.CorrelationValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.EmptyValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExitValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExtensionActivityValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExtensionValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ExtensionsValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.FaultHandlersValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.FlowValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ForEachValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.FromValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.IfValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ImportValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.InvokeValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.LiteralValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.OnMessageValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.PartnerLinkValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.PickValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ProcessValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.QueryValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ReThrowValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ReceiveValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.RepeatUntilValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ReplyValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ScopeValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.SequenceValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ThrowValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ToValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.VariableValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.WaitValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.WhileValidatorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Warning;

public class BPELValidator {

	private static BPELReader reader = null;

	private static BPELException readerEx = null;

	private final DocumentBuilderFactory factory;

	static {
		try {
			reader = BPELFactoryImpl.getInstance().newBPELReader();
		} catch (final BPELException e) {
			readerEx = e;
		}
	}

	public static BPELReader getBPELReader() throws BPELException {
		if (readerEx != null) {
			throw readerEx;
		}
		return reader;
	}

	public BPELValidator() throws BPELException {
		BPELValidator.getBPELReader();
		this.factory = DocumentBuilderFactory.newInstance();
		this.factory.setNamespaceAware(true);
	}

	public ValidatorResult validate(final URL bpel) {
		ValidatorResult res = null;
		try {

			final URI bpelURI = URLUtil.urlToUri(bpel);
			final InputStream is = bpel.openStream();


			final Document bpelSrcDoc = this.factory.newDocumentBuilder().parse(is);
			final Document bpeltargetDoc = DoXslTransformFunctionImpl.process(Thread
					.currentThread().getContextClassLoader().getResource(
					"xslt/upperYesAndNoAttribute.xsl"), bpelSrcDoc,
					null);

			if (bpeltargetDoc.getDocumentURI() == null) {
				bpeltargetDoc.setDocumentURI(bpelURI.toString());
			}
			// END OF FIX BUGS

			res = this.validate(bpeltargetDoc);

		} catch (final IOException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		} catch (final SAXException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		} catch (final ParserConfigurationException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		} catch (XPathExpressionException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		}

		return res;
	}


	public ValidatorResult validate(final Document bpel) {
		final ValidatorResult res = new ValidatorResult();
		try {
			// clean static analysis
			BPELStaticAnalysisImpl.getInstance().getErrors().clear();
			BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
			BPELStaticAnalysisImpl.getInstance().getInfos().clear();


			BPELValidator.getBPELReader().readBPEL(bpel);

			// get errors from static analysis
			for (final Error e : BPELStaticAnalysisImpl
					.getInstance().getErrors()) {
				res.getErrors().add(new XPathError((BPELError)e));
			}

			// get warnings from static analysis
			for (final Warning w : BPELStaticAnalysisImpl.getInstance().getWarnings()) {
				res.getWarnings().add(new XPathWarning((BPELWarning)w));
			}

			// get infos from static analysis
			for (final Info i : BPELStaticAnalysisImpl.getInstance().getInfos()) {
				res.getInfos().add(new XPathInfo((BPELInfo)i));
			}

		} catch (final BPELException e) {
			res.getErrors().add(new XPathError(null, e));
			e.printStackTrace();
		} 

		return res;
	}


	public ValidatorResult validate(final BPELProcess bpel) {
		final ValidatorResult res = new ValidatorResult();

		// clean static analysis
		BPELStaticAnalysisImpl.getInstance().getErrors().clear();
		BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
		BPELStaticAnalysisImpl.getInstance().getInfos().clear();

		this.validateElmt((BPELElement)bpel);

		// get errors from static analysis
		for (final Error e : BPELStaticAnalysisImpl
				.getInstance().getErrors()) {
			res.getErrors().add(new XPathError((BPELError)e));
		}

		// get warnings from static analysis
		for (final Warning w : BPELStaticAnalysisImpl.getInstance().getWarnings()) {
			res.getWarnings().add(new XPathWarning((BPELWarning)w));
		}

		// get infos from static analysis
		for (final Info i : BPELStaticAnalysisImpl.getInstance().getInfos()) {
			res.getInfos().add(new XPathInfo((BPELInfo)i));
		}

		return res;
	}


	private void validateElmt(final BPELElement elmt) {
		if(elmt != null) {
			if(elmt instanceof BPELProcess) {
				new ProcessValidatorImpl((BPELProcess) elmt).validate();
				for(Import impt: ((BPELProcess) elmt).getImports().getBPELImports()) {
					this.validateElmt(impt);
				}
				for(PartnerLink pl: ((BPELProcess) elmt).getPartnerLinks()) {
					this.validateElmt(pl);
				}
				for(BPELVariable var: ((BPELProcess) elmt).getVariables()) {
					this.validateElmt(var);
				}
				for(CorrelationSet corr: ((BPELProcess) elmt).getCorrelationSets()) {
					this.validateElmt(corr);
				}
				this.validateElmt(((BPELProcess) elmt).getFaultHandlers());
				this.validateElmt(((BPELProcess) elmt).getExtensions());
				this.validateElmt(((BPELProcess) elmt).getActivity());
			} else if(elmt instanceof Scope) {
				new ScopeValidatorImpl((Scope) elmt).validate();
				for(PartnerLink pl: ((Scope) elmt).getPartnerLinks()) {
					this.validateElmt(pl);
				}
				for(BPELVariable var: ((Scope) elmt).getVariables()) {
					this.validateElmt(var);
				}
				this.validateElmt(((Scope) elmt).getFaultHandlers());
				this.validateElmt(((Scope) elmt).getActivity());
			} else if(elmt instanceof Import) {
				new ImportValidatorImpl((Import) elmt).validate();
			} else if(elmt instanceof PartnerLink) {
				new PartnerLinkValidatorImpl((PartnerLink) elmt).validate();
			} else if(elmt instanceof Extensions) {
				new ExtensionsValidatorImpl((Extensions) elmt).validate();
			} else if(elmt instanceof Extension) {
				new ExtensionValidatorImpl((Extension) elmt).validate();
			} else if(elmt instanceof BPELVariable) {
				new VariableValidatorImpl((BPELVariable) elmt).validate();
			} else if(elmt instanceof CorrelationSet) {
				new CorrelationSetValidatorImpl((CorrelationSet) elmt).validate();
			} else if(elmt instanceof Correlation) {
				new CorrelationValidatorImpl((Correlation) elmt).validate();
			} else if(elmt instanceof FaultHandlers) {
				new FaultHandlersValidatorImpl((FaultHandlers) elmt).validate();
				for(Catch c: ((FaultHandlers) elmt).getCatchs()) {
					this.validateElmt(c);
				}
				this.validateElmt(((FaultHandlers) elmt).getCatchAll());
			} else if(elmt instanceof Catch) {
				new CatchValidatorImpl((Catch) elmt).validate();
				this.validateElmt(((Catch) elmt).getActivity());
			} else if(elmt instanceof Throw) {
				new ThrowValidatorImpl((Throw) elmt).validate();
			} else if(elmt instanceof Receive) {
				new ReceiveValidatorImpl((Receive) elmt).validate();
			} else if(elmt instanceof Reply) {
				new ReplyValidatorImpl((Reply) elmt).validate();
			} else if(elmt instanceof Invoke) {
				new InvokeValidatorImpl((Invoke) elmt).validate();
			} else if(elmt instanceof Wait) {
				new WaitValidatorImpl((Wait) elmt).validate();
			} else if(elmt instanceof Empty) {
				new EmptyValidatorImpl((Empty) elmt).validate();
			} else if(elmt instanceof Sequence) {
				new SequenceValidatorImpl((Sequence) elmt).validate();
				for(Activity a : ((Sequence) elmt).getActivities()) {
					this.validateElmt(a);
				}
			} else if(elmt instanceof If) {
				new IfValidatorImpl((If) elmt).validate();
				for(Activity a : ((If) elmt).getActivities()) {
					this.validateElmt(a);
				}
			} else if(elmt instanceof While) {
				new WhileValidatorImpl((While) elmt).validate();
				this.validateElmt(((While) elmt).getActivity());
			} else if(elmt instanceof RepeatUntil) {
				new RepeatUntilValidatorImpl((RepeatUntil) elmt).validate();
				this.validateElmt(((RepeatUntil) elmt).getActivity());
			} else if(elmt instanceof ForEach) {
				new ForEachValidatorImpl((ForEach) elmt).validate();
				this.validateElmt(((ForEach) elmt).getScope());
			} else if(elmt instanceof Pick) {
				new PickValidatorImpl((Pick) elmt).validate();
				for(OnMessage om : ((Pick) elmt).getOnMessages()) {
					this.validateElmt(om);
				}
			} else if(elmt instanceof OnMessage) {
				new OnMessageValidatorImpl((OnMessage) elmt).validate();
			} else if(elmt instanceof Flow) {
				new FlowValidatorImpl((Flow) elmt).validate();
				for(Activity a : ((Flow) elmt).getActivities()) {
					this.validateElmt(a);
				}
			} else if(elmt instanceof Exit) {
				new ExitValidatorImpl((Exit) elmt).validate();
			} else if(elmt instanceof ReThrow) {
				new ReThrowValidatorImpl((ReThrow) elmt).validate();
			} else if(elmt instanceof Assign) {
				new AssignValidatorImpl((Assign) elmt).validate();
			} else if(elmt instanceof Copy) {
				new CopyValidatorImpl((Copy) elmt).validate();
			} else if(elmt instanceof From) {
				new FromValidatorImpl((From) elmt).validate();
			} else if(elmt instanceof To) {
				new ToValidatorImpl((To) elmt).validate();
			} else if(elmt instanceof Query) {
				new QueryValidatorImpl((Query) elmt).validate();
			} else if(elmt instanceof Literal) {
				new LiteralValidatorImpl((Literal) elmt).validate();
			} else if(elmt instanceof ExtensionActivity) {
				new ExtensionActivityValidatorImpl((ExtensionActivity) elmt).validate();
			} else {
				 BPELStaticAnalysisImpl.getInstance().addWarning(new BPELWarningImpl(elmt, "this BPLElement " + elmt.getClass() + " has not validator"));
			}
		}
	}
}
