/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader.FeatureConstants;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.factory.AbstractFactoryImpl;
import com.ebmwebsourcing.easyviper.core.api.factory.Factory;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;

/**
 * This abstract class defines a factory API that enables applications to obtain
 * a BPELFactory capable of producing new Definitions, new WSDLReaders, and new
 * WSDLWriters.
 *
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class BPELFactory extends AbstractFactoryImpl<ConfigurationEngineImpl> implements Factory<ConfigurationEngineImpl> {
	
	public static String DEFAULT_NAME = "BpelEngine";

    /**
     * Get a new instance of a BPELFactory. This method follows (almost) the
     * same basic sequence of steps that JAXP follows to determine the
     * fully-qualified class name of the class which implements BPELFactory.
     * <p>
     * The steps in order are:
     * <ol>
     * <li>Check the property file
     * META-INF/services/javax.wsdl.factory.WSDLFactory.</li>
     * <li>Check the javax.wsdl.factory.WSDLFactory system property.</li>
     * <li>Check the lib/wsdl.properties file in the JRE directory. The key will
     * have the same name as the above system property.</li>
     * <li>Use the default class name provided by the implementation.</li>
     * </ol>
     * <p>
     * Once an instance of a BPELFactory is obtained, invoke newDefinition(),
     * newWSDLReader(), or newWSDLWriter(), to create the desired instances.
     */
    public static BPELFactory newInstance() throws BPELException {
        return new BPELFactoryImpl();
    }

    /**
     * Create a new instance of a BPELReaderImpl.
     * @throws BPELException
     */
    public abstract BPELReader newBPELReader() throws BPELException;

    /**
     * Create a new instance of a BPELReaderImpl.
     * @throws BPELException
     */
    public abstract BPELReader newBPELReader(Map<FeatureConstants, Object> features) throws BPELException;

    /**
     * Create a new instance of a BPELWriterImpl.
     * @throws BPELException
     */
    public abstract BPELWriter newBPELWriter() throws BPELException;

    /**
     * Create the registry of process.
     * @throws BPELException
     */
    public abstract Core newBPELEngine(ConfigurationEngine cong, MessageConverter converter, 
    		int numberOfReceivers, Class<? extends Receiver> receiverClass,
			int numberOfSenders, Class<? extends Sender> senderClass, Logger logger) throws BPELException;
    
    public abstract Core newBPELEngine(MessageConverter converter, int numberOfReceivers, Class<? extends Receiver> receiverClass,
			int numberOfSenders, Class<? extends Sender> senderClass) throws BPELException;

    /**
     * Create a new instance of a BPELWriterImpl.
     */
    public abstract void setJAXBObjectFactoryList(List<Class<?>> objectFactories);

}
