/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivityContainer;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TElseif;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExit;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TForEach;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRethrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TThrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.extensionactivities.Breakpoint;
import com.ebmwebsourcing.easybpel.model.bpel.extensionactivities.Echo;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension.BreakpointActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension.DebugActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension.EchoActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.containers.ContainersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.containers.SourcesImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.containers.TargetsImpl;




/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class ActivityImpl<E extends TActivity> extends ContainersImpl<E> implements Activity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(BPELProcessImpl.class.getName());

	private Sources sources = null;

	private Targets targets = null;

	@SuppressWarnings("unchecked")
	public ActivityImpl(final QName name, final E model, final BPELElement parent) {
		super(name, model, parent);
		if(model != null) {
			if(this.model.getSources() != null) {
				this.sources = new SourcesImpl(this.model.getSources(), this);
			}
			if(this.model.getTargets() != null) {
				this.targets = new TargetsImpl(this.model.getTargets(), this);
			}
		}
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new XmlException("Not yet implemented");
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(final String name) {
		this.model.setName(name);
	}

	public Sources getSources() {
		return this.sources;
	}

	public boolean getSuppressJoinFailure() {
		return Boolean.valueOf(this.model.getSuppressJoinFailure().value);
	}

	public Targets getTargets() {
		return this.targets;
	}


	public static Activity getActivity(final TActivity internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		if(internalActivity instanceof TIf) {
			res = new IfImpl((TIf) internalActivity, parent);
		} else if(internalActivity instanceof TEmpty) {
			res = new EmptyImpl((TEmpty) internalActivity, parent);
		} else if(internalActivity instanceof TWait) {
			res = new WaitImpl((TWait) internalActivity, parent);
		} else if(internalActivity instanceof TSequence) {
			res = new SequenceImpl((TSequence) internalActivity, parent);
		} else if(internalActivity instanceof TFlow) {
			res = new FlowImpl((TFlow) internalActivity, parent);
		} else if(internalActivity instanceof TWhile) {
			res = new WhileImpl((TWhile) internalActivity, parent);
		} else if(internalActivity instanceof TForEach) {
			res = new ForEachImpl((TForEach) internalActivity, parent);
		} else if(internalActivity instanceof TRepeatUntil) {
			res = new RepeatUntilImpl((TRepeatUntil) internalActivity, parent);
		} else if(internalActivity instanceof TInvoke) {
			res = new InvokeImpl((TInvoke) internalActivity, parent);
		} else if(internalActivity instanceof TReceive) {
			res = new ReceiveImpl((TReceive) internalActivity, parent);
		} else if(internalActivity instanceof TReply) {
			res = new ReplyImpl((TReply) internalActivity, parent);
		} else if(internalActivity instanceof TAssign) {
			res = new AssignImpl((TAssign) internalActivity, parent);
		} else if(internalActivity instanceof TPick) {
			res = new PickImpl((TPick) internalActivity, parent);
		} else if(internalActivity instanceof TScope) {
			res = new ScopeImpl((TScope) internalActivity, parent);
		} else if(internalActivity instanceof TThrow) {
			res = new ThrowImpl((TThrow) internalActivity, parent);
		} else if(internalActivity instanceof TRethrow) {
			res = new ReThrowImpl((TRethrow) internalActivity, parent);
		} else if (internalActivity instanceof TExit) {
			res =  new ExitImpl((TExit)internalActivity, parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but the activity " + internalActivity.getName() + " is unrecognized or not supported by BPEL engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but the activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}


	public static Activity analyzeIfActivity(final TIf internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TIf temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeOnMessageActivity(final TOnMessage internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TOnMessage temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside the onMessage for operation " + temp.getOperation() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside the onMessage for operation " + temp.getOperation() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeWhileActivity(final TWhile internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TWhile temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeRepeatUntilActivity(final TRepeatUntil internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TRepeatUntil temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction]  Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction]  Sorry, but a child activity inside this activity " + internalActivity.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeElseIfActivity(final TElseif internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TElseif temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this else activity " + internalActivity + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException( "[BPEL engine restriction] Sorry, but a child activity inside this else activity " + internalActivity + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeActivityContainer(final TActivityContainer internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TActivityContainer temp = internalActivity;
		if(temp.getEmpty() != null) {
			res = new EmptyImpl(temp.getEmpty(), parent);
		} else if(temp.getWait() != null) {
			res = new WaitImpl(temp.getWait(), parent);
		} else if(temp.getSequence() != null) {
			res = new SequenceImpl(temp.getSequence(), parent);
		} else if(temp.getFlow() != null) {
			res = new FlowImpl(temp.getFlow(), parent);
		} else if(temp.getIf() != null) {
			res = new IfImpl(temp.getIf(), parent);
		} else if(temp.getWhile() != null) {
			res = new WhileImpl(temp.getWhile(), parent);
		} else if(temp.getForEach() != null) {
			res = new ForEachImpl(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = new RepeatUntilImpl(temp.getRepeatUntil(), parent);
		} else if(temp.getAssign() != null) {
			res = new AssignImpl(temp.getAssign(), parent);
		} else if(temp.getPick() != null) {
			res = new PickImpl(temp.getPick(), parent);
		} else if(temp.getScope() != null) {
			res = new ScopeImpl(temp.getScope(), parent);
		} else if(temp.getInvoke() != null) {
			res = new InvokeImpl(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = new ReceiveImpl(temp.getReceive(), parent);
		} else if(temp.getReply() != null) {
			res = new ReplyImpl(temp.getReply(), parent);
		} else if(temp.getThrow() != null) {
			res = new ThrowImpl(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = new ReThrowImpl(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = new ExitImpl(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getClass().getSimpleName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + internalActivity.getClass().getSimpleName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}

	public static Activity analyzeScope(final TScope temp, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		if(temp.getAssign() != null) {
			res = ActivityImpl.getActivity(temp.getAssign(), parent);
		} else if(temp.getEmpty() != null) {
			res = ActivityImpl.getActivity(temp.getEmpty(), parent);
		} else if(temp.getFlow() != null) {
			res = ActivityImpl.getActivity(temp.getFlow(), parent);
		} else if(temp.getForEach() != null) {
			res = ActivityImpl.getActivity(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getIf() != null) {
			res = ActivityImpl.getActivity(temp.getIf(), parent);
		} else if(temp.getInvoke() != null) {
			res = ActivityImpl.getActivity(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = ActivityImpl.getActivity(temp.getReceive(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getReply() != null) {
			res = ActivityImpl.getActivity(temp.getReply(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getSequence() != null) {
			res = ActivityImpl.getActivity(temp.getSequence(), parent);
		} else if(temp.getWait() != null) {
			res = ActivityImpl.getActivity(temp.getWait(), parent);
		} else if(temp.getWhile() != null) {
			res = ActivityImpl.getActivity(temp.getWhile(), parent);
		} else if(temp.getThrow() != null) {
			res = ActivityImpl.getActivity(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = ActivityImpl.getActivity(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = ActivityImpl.getActivity(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}


	public static Activity analyzeProcess(final TProcess temp, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		if(temp.getAssign() != null) {
			res = ActivityImpl.getActivity(temp.getAssign(), parent);
		} else if(temp.getEmpty() != null) {
			res = ActivityImpl.getActivity(temp.getEmpty(), parent);
		} else if(temp.getFlow() != null) {
			res = ActivityImpl.getActivity(temp.getFlow(), parent);
		} else if(temp.getForEach() != null) {
			res = ActivityImpl.getActivity(temp.getForEach(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getIf() != null) {
			res = ActivityImpl.getActivity(temp.getIf(), parent);
		} else if(temp.getInvoke() != null) {
			res = ActivityImpl.getActivity(temp.getInvoke(), parent);
		} else if(temp.getReceive() != null) {
			res = ActivityImpl.getActivity(temp.getReceive(), parent);
		} else if(temp.getRepeatUntil() != null) {
			res = ActivityImpl.getActivity(temp.getRepeatUntil(), parent);
		} else if(temp.getReply() != null) {
			res = ActivityImpl.getActivity(temp.getReply(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getScope() != null) {
			res = ActivityImpl.getActivity(temp.getScope(), parent);
		} else if(temp.getSequence() != null) {
			res = ActivityImpl.getActivity(temp.getSequence(), parent);
		} else if(temp.getWait() != null) {
			res = ActivityImpl.getActivity(temp.getWait(), parent);
		} else if(temp.getWhile() != null) {
			res = ActivityImpl.getActivity(temp.getWhile(), parent);
		} else if(temp.getThrow() != null) {
			res = ActivityImpl.getActivity(temp.getThrow(), parent);
		} else if(temp.getRethrow() instanceof TRethrow) {
			res = ActivityImpl.getActivity(temp.getRethrow(), parent);
		} else if (temp.getExit() instanceof TExit) {
			res = ActivityImpl.getActivity(temp.getExit(), parent);
		} else {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Sorry, but a child activity inside this activity " + temp.getName() + " is unrecognized or not supported by Bpel Engine for the moment or is null")));
		}
		return res;
	}


	@SuppressWarnings("unchecked")
	public static Activity analyzeExtensionActivity(final TExtensionActivity internalActivity, final BPELElementImpl parent) throws BPELException {
		Activity res = null;
		final TExtensionActivity temp = internalActivity;

		if(temp.getAny() != null) {
			if(temp.getAny() instanceof JAXBElement) {
				final JAXBElement elmt = (JAXBElement)temp.getAny();
				if((elmt.getName().getNamespaceURI().equals("http://orchestration.ebmwebsourcing.com/ExtensionActivities"))&&
						(elmt.getName().getLocalPart().equals("debug"))) {
					res = new DebugActivityImpl((Boolean) elmt.getValue(), parent);
				} else if((elmt.getName().getNamespaceURI().equals("http://orchestration.ebmwebsourcing.com/ExtensionActivities"))&&
						(elmt.getName().getLocalPart().equals("breakpoint"))) {
					res = new BreakpointActivityImpl( (Breakpoint) elmt.getValue(), parent);
				} else if((elmt.getName().getNamespaceURI().equals("http://orchestration.ebmwebsourcing.com/ExtensionActivities"))&&
						(elmt.getName().getLocalPart().equals("echo"))) {
					res = new EchoActivityImpl( (Echo) elmt.getValue(), parent);
				} 
			} else if(temp.getAny() instanceof Element) {
				res = DebugActivityImpl.analyseDOMElementInTExtensionActivity((Element) temp.getAny());
				if(res == null) {
					res = BreakpointActivityImpl.analyseDOMElementInTExtensionActivity((Element) temp.getAny());
				} else if(res == null) {
					res = EchoActivityImpl.analyseDOMElementInTExtensionActivity((Element) temp.getAny());
				} 
			}

			if(res == null){
				StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(parent, "[BPEL engine restriction] Unknown extensionActivity: " + internalActivity));
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(parent, new BPELException("[BPEL engine restriction] Unknown extensionActivity: " + internalActivity)));
			}
		} 
		return res;
	}
}
