/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ReplyImpl extends ActivityImpl<TReply> implements Reply {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final List<Correlation> correlations = new ArrayList<Correlation>();

	public ReplyImpl(final TReply model, final BPELElement parent) {
		super(Constants._Reply_QNAME, model, parent);
		
		if(this.model.getCorrelations() != null) {
			for(final TCorrelation corr: this.model.getCorrelations().getCorrelation()) {
				this.correlations.add(new CorrelationImpl(corr, this.model.getCorrelations(), this)); 
			}
		}
	}

	public QName getInterface() {
		return this.model.getPortType();
	}




	public String getOutputVariable() {
		return this.model.getVariable();
	}




	public String getPartnerLink() {
		return this.model.getPartnerLink();
	}


	public List<Correlation> getCorrelations() {
		return this.correlations;
	}

	public String getOperation() {
		return this.model.getOperation();
	}

}
