/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.net.URI;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Query;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TQuery;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;


public class QueryImpl extends BPELElementImpl<TQuery>implements Query {
	

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public QueryImpl(final TQuery model, final BPELElement parent) {
		super(Constants._Query_QNAME, model, parent);
	}

	public String getContent() {
		String def = null;
		if((this.model != null) && (this.model.getContent() != null) && (this.model.getContent().size() > 0)) {
			def = (String) this.model.getContent().get(0);
			for(final Object s: this.model.getContent()) {
				if((s != null) && (s.toString().trim().length() > 0)) {
					def = (String) s;
				}
			}
		}
		return def;
	}

	public URI getQueryLanguage() {
		URI res = null;
		if(this.model.getQueryLanguage() != null) {
			res = URI.create(this.model.getQueryLanguage());
		}
		return res;
	}

	public void setContent(final String content) {
		this.model.getContent().clear();
		this.model.getContent().add(content);
	}

	public void setQueryLanguage(final URI language) {
		this.model.setQueryLanguage(language.toString());
	}

	@Override
	public String toString() {
		String res = null;
		if(this.getContent() != null) {
			res = this.getContent().trim();
		}
		return res;
	}

}
