/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Query;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class VariablePartImpl implements VariablePart {

	private String part;
	
	private QName variable;
	
	private Query query;
	
	public VariablePartImpl(final QName variable, final String part, final Query query) {
		this.part = part;
		this.variable = variable;
		this.query = query;
	}
	
	public String getPart() {
		return this.part;
	}

	public Query getQuery() {
		return this.query;
	}

	public QName getVariable() {
		return this.variable;
	}

	public void setPart(final String part) {
		this.part = part;
	}

	public void setQuery(final Query q) {
		this.query = q;
	}

	public void setVariable(final QName name) {
		this.variable = name;
	}

	@Override
	public String toString() {
		String res = null;
		if(this.getVariable() != null) {
			res = "$" + this.getVariable();
			if(this.getPart() != null) {
				res = res + "." + this.getPart();
			}
			if(this.getQuery() != null) {
				res = res + "/" + this.getQuery();
			}
		}
		return res;
	}

	
	
}
