/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.BreakpointActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.extensionactivities.Breakpoint;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELReaderImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BreakpointActivityImpl extends ExtensionActivityImpl<Breakpoint> implements BreakpointActivity {



	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	public BreakpointActivityImpl(final Breakpoint model, final BPELElementImpl parent) {
		super(model, parent);
	}
	
	public static BreakpointActivity analyseDOMElementInTExtensionActivity(final Element child) throws BPELException {
		BreakpointActivity res = null;
		try {
			final BPELReader reader = BPELFactory.newInstance().newBPELReader(); 
			if((child != null)&&((child.getLocalName().equals("breakpoint"))&&(child.getNamespaceURI().equals(Constants.BPEL_20_EBM_EXT_PROP_NAMESPACE)))) {
				JAXBElement<Breakpoint> jaxbElement;
				jaxbElement = ((BPELReaderImpl)reader).getJaxbContext().createUnmarshaller().unmarshal(child, Breakpoint.class);

				// create bpel element
				res = new BreakpointActivityImpl(jaxbElement.getValue(), null);
			}
		} catch (final JAXBException e) {
			e.printStackTrace();
			// do nothing
		}
		return res;
	}
}
