/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.DebugActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELReaderImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DebugActivityImpl extends ExtensionActivityImpl<Boolean> implements DebugActivity {



	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	public DebugActivityImpl(final Boolean model, final BPELElementImpl parent) {
		super(model, parent);
	}
	
	public static DebugActivity analyseDOMElementInTExtensionActivity(final Element child) throws BPELException {
		DebugActivity res = null;
		try {
			final BPELReader reader = BPELFactory.newInstance().newBPELReader(); 
			if((child != null)&&((child.getLocalName().equals("debug"))&&(child.getNamespaceURI().equals(Constants.BPEL_20_EBM_EXT_PROP_NAMESPACE)))) {
				JAXBElement<Boolean> jaxbElement;
				jaxbElement = ((BPELReaderImpl)reader).getJaxbContext().createUnmarshaller().unmarshal(child, Boolean.class);

				// create bpel element
				res = new DebugActivityImpl(jaxbElement.getValue(), null);
			}
		} catch (final JAXBException e) {
			// do nothing
		}
		return res;
	}

	public boolean isDebug() {
		return this.model;
	}
}
