/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension;

import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensibleElements;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELReaderImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ExtensionActivityImpl<E> extends BPELElementImpl<E> implements ExtensionActivity {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	

	public ExtensionActivityImpl(final E model, final BPELElementImpl parent) {
		super(Constants._ExtensionActivity_QNAME, model, parent);
	}


	@Override
	public List<Element> getOtherElements() throws XmlException {
		return null;
	}


	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return null;
	}
	
	
	public static ExtensionActivity replaceDOMElementByTExtensionActivity(final BPELReader reader, final BPELElement parent, final Element childToReplace) throws BPELException {
		ExtensionActivity res = null;
		try {
			if((childToReplace != null)&&((childToReplace.getLocalName().equals("extensionActivity"))&&(childToReplace.getNamespaceURI().equals(Constants.BPEL_20_EXECUTABLE_NAMESPACE)))) {
				JAXBElement<TExtensionActivity> jaxbElement;
				jaxbElement = ((BPELReaderImpl)reader).getJaxbContext().createUnmarshaller().unmarshal(childToReplace, TExtensionActivity.class);

				// change element by jaxb element
				((TExtensibleElements)((BPELElementImpl)parent).getModel()).getAny().remove(childToReplace);
				((TExtensibleElements)((BPELElementImpl)parent).getModel()).getAny().add(jaxbElement);

				// create bpel element
				res = (ExtensionActivity) ActivityImpl.analyzeExtensionActivity(jaxbElement.getValue(), (BPELElementImpl) parent);
				if(res == null) {
					res = new ExtensionActivityImpl(jaxbElement.getValue(), (BPELElementImpl) parent);
				}
			}
		} catch (final JAXBException e) {
			throw new BPELException(e);
		}
		return res;
	}


	public String getName() {
		return null;
	}
	
	
	public void setName(final String name) {
		
	}

	public Sources getSources() {
		return null;
	}


	public boolean getSuppressJoinFailure() {
		return false;
	}


	public Targets getTargets() {
		return null;
	}
	

}
