/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ActivityValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivity;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class ActivityValidatorImpl<A extends Activity> implements ActivityValidator<A> {

	private A activity = null;
	
	public ActivityValidatorImpl(final A activity) {
		this.activity = activity;
	}
	
	public void validate() {
		// validation
		if(((TActivity)((BPELElementImpl)this.activity).getModel()).getSources() != null) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.activity, "[BPEL engine restriction] Sorry, but \"sources\" elements are not supported for the moment"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.activity, new BPELException("[BPEL engine restriction] Sorry, but \"sources\" elements are not supported for the moment")));
		}
		if(((TActivity)((BPELElementImpl)this.activity).getModel()).getTargets() != null) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.activity, "[BPEL engine restriction] Sorry, but \"targets\" elements are not supported for the moment"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.activity, new BPELException("[BPEL engine restriction] Sorry, but \"sources\" elements are not supported for the moment")));

		}
		if(((TActivity)((BPELElementImpl)this.activity).getModel()).getSuppressJoinFailure() != null) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.activity, "[BPEL engine restriction] Sorry, but the suppressJoinFailure attribute is ignored for the moment"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.activity, new BPELException("[BPEL engine restriction] Sorry, but \"sources\" elements are not supported for the moment")));
		}
	}

	public A getActivity() {
		return this.activity;
	}
}
