/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.FlowValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class FlowValidatorImpl extends ActivityValidatorImpl<Flow> implements FlowValidator {


	public FlowValidatorImpl(final Flow flow) {
		super(flow);
	}

	@Override
	public void validate() {
		// validation

		if((((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getActivity() == null) || (((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getActivity().size() == 0)) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In flow " + this.getActivity().getName() + " => A flow MUST have at less one activity.")));
		}
		
		if((((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getLinks() != null) && (((TFlow)((BPELElementImpl)this.getActivity()).getModel()).getLinks().getLink().size() > 0)) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In flow " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but links ares not supported for the moment."));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In flow " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but links ares not supported for the moment.")));
		}
	}

}
