/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.net.URI;

import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription.WSDLVersionConstants;

import com.ebmwebsourcing.easybpel.model.bpel.XMLConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PartnerLinkValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.WarningImpl;

public class ImportValidatorImpl implements PartnerLinkValidator {

	private Import _import = null;

	public ImportValidatorImpl(final Import _import) {
		this._import = _import;
	}

	public void validate() {
		// validation

		// validation if null or empty
		if((this._import.getImportType() == null) || (this._import.getImportType().toString().trim().length() == 0)) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this._import, new BPELException("In one import => the importType cannot be null or empty")));
		}
		if((this._import.getLocation() == null) || (this._import.getLocation().toString().trim().length() == 0)) {
			StaticAnalysisImpl.getInstance().addWarning(new WarningImpl(this._import, "In one import => the location is null or empty"));
		}
		if((this._import.getNamespace() == null) || (this._import.getNamespace().toString().trim().length() == 0)) {
			StaticAnalysisImpl.getInstance().addWarning(new WarningImpl(this._import, "In one import => the namespace is null or empty"));
		}

		// validation the content
		final BPELProcess process = ScopeImpl.getProcess(this._import);
		final URI baseUri = process.getDocumentBaseURI();
		if(this._import.getImportType() != null) {
			if((!this._import.getImportType().toString().equals(WSDLVersionConstants.WSDL11.value().toString())) &&
					(!this._import.getImportType().toString().equals(WSDLVersionConstants.WSDL20.value().toString())) &&
					(! this._import.getImportType().toString().equals(XMLConstants.W3C_XML_SCHEMA_NS_URI))) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this._import, new BPELException(StaticAnalysis.SA0013)));
			}
		}
	}

}
