/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.OnMessageValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class OnMessageValidatorImpl implements OnMessageValidator {

	private static Logger log = Logger.getLogger(OnMessageValidatorImpl.class.getName());
	
	private OnMessage message = null;
	
	public OnMessageValidatorImpl(final OnMessage onMessage) {
		this.message = onMessage;
	}
	
	public void validate() {
		
		// validation
		log.finest("validate onMessage");
		try {
			// unsupported element
			
			if((((TOnMessage)((BPELElementImpl)this.message).getModel()).getFromParts() != null) && (((TOnMessage)((BPELElementImpl)this.message).getModel()).getFromParts().getFromPart().size() > 0)) {
				StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead"));
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead")));
			}
			if(((TOnMessage)((BPELElementImpl)this.message).getModel()).getMessageExchange() != null) {
				StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment."));
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment.")));
			}
			
			// validation if null or empty
			if((this.message.getPartnerLink() == null) || (this.message.getPartnerLink().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => the partnerLink cannot be null or empty")));
			}
			if((this.message.getOperation() == null) || (this.message.getOperation().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => the operation cannot be null or empty")));
			}
			if((this.message.getInputVariable() == null) || (this.message.getInputVariable().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => the input variable cannot be null or empty")));
			}

			// validation if exist

			// find partnerLink
			if((this.message.getPartnerLink() != null) && (this.message.getPartnerLink().trim().length() > 0)) {
				final PartnerLink partnerLink = ScopeImpl.findPartnerLinkRecursively(this.message.getPartnerLink(), (BPELElement) ((BPELElementImpl)this.message).getParent());
				if(partnerLink == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find partnerLink corresponding to the name: " + this.message.getPartnerLink())));
				}

				// find operation
				if((this.message.getOperation() != null) && (this.message.getOperation().trim().length() > 0)) {
					if(partnerLink != null) {
						final BPELProcess process = ScopeImpl.getProcess((this.message));

						final List<AbsItfInterfaceType> itfsToVerify = new ArrayList<AbsItfInterfaceType>();
						if(this.message.getInterface() != null) {
							final InterfaceType itf = process.getImports().getInterface(this.message.getInterface());
							if(itf != null) {
								itfsToVerify.add(itf);
							}
						} else {
							final PartnerLinkType plt = process.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
							if(((partnerLink.getMyRole() == null) || (partnerLink.getMyRole().trim().length() == 0))&&
									((partnerLink.getPartnerRole() == null) || (partnerLink.getPartnerRole().trim().length() == 0))) {
								// get all role of partnerLink type
								for(final Role r: plt.getRoles()) {
									itfsToVerify.add(r.getInterface());
								}
							} else {
								if((partnerLink.getMyRole() != null) && (partnerLink.getMyRole().trim().length() > 0)) {
									for(final Role r: plt.getRoles()) {
										if(r.getName().equals(partnerLink.getMyRole())) {
											itfsToVerify.add(r.getInterface());
											break;
										}
									}
								} 
								if((partnerLink.getPartnerRole() != null) && (partnerLink.getPartnerRole().trim().length() > 0)) {
									for(final Role r: plt.getRoles()) {
										if(r.getName().equals(partnerLink.getPartnerRole())) {
											itfsToVerify.add(r.getInterface());
											break;
										}
									}
								}
							}
						}
						final List<AbsItfOperation> ops = new ArrayList<AbsItfOperation>();
						if(itfsToVerify.size() == 0) {
							if(this.message.getInterface() != null) {
								StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType: " + this.message.getInterface())));
							} else {
								StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find portType. You must add portType attribute in receive or add a role to the partnerLink of receive")));
							}
						}

						for(final AbsItfInterfaceType itf: itfsToVerify) {
							final AbsItfOperation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.message.getOperation()));
							if(op != null) {
								ops.add(op);
							}
						}

						if(ops.size() == 0) {
							StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the operation: " + this.message.getOperation())));
						} else if(ops.size() > 1) {
							String itfString = null;
							for(final AbsItfOperation op: ops) {
								if(itfString == null) {
									itfString = ((AbsItfInterfaceType)((AbstractWSDLElementImpl)op).getParent()).getQName().toString();
								} else {
									itfString = itfString + ", " + ((AbsItfInterfaceType)((AbstractWSDLElementImpl)op).getParent()).getQName().toString();
								}
							}
							StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => Several interfaces match with the operation " + this.message.getOperation() + ": " + itfString + ". " +  "You must add portType attribute in receive or add a role to the partnerLink of receive")));
						}

					}



				}

			}

			// find variable
			if((this.message.getInputVariable() != null) && (this.message.getInputVariable().trim().length() > 0)) {
				final BPELVariable var = ScopeImpl.findVariableRecursively(new QName(this.message.getInputVariable()), (BPELElement) ((BPELElementImpl)this.message).getParent());
				if(var == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find input variable corresponding to the name: " + this.message.getInputVariable())));
				}
			}
		} catch (final WSDL4BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.message, new BPELException("In OnMessage => " + e.getMessage())));
		}
	}

}
