/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ScopeValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class ScopeValidatorImpl extends ActivityValidatorImpl<Scope> implements ScopeValidator {

	
	public ScopeValidatorImpl(final Scope scope) {
		super(scope);
	}

	@Override
	public void validate() {
		super.validate();
		
		// validation

		// validation if null or empty
		if(((TScope)((BPELElementImpl)this.getActivity()).getModel()).getIsolated().equals(TBoolean.YES)) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In receive " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the attribute isolated to yes is currently ignored."));
		}
		
		// restriction: ignored 
		if(((TScope)((BPELElementImpl)this.getActivity()).getModel()).getSuppressJoinFailure() != null) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In scope => [BPEL engine restriction] Sorry, but the suppressJoinFailure attribute is ignored for the moment"));
		}
		if(((TScope)((BPELElementImpl)this.getActivity()).getModel()).getExitOnStandardFault() != null) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In scope => [BPEL engine restriction] Sorry, but the exitOnStandardFault attribute is ignored for the moment"));
		}
		
		// restriction: error 
		if((((TScope)((BPELElementImpl)this.getActivity()).getModel()).getMessageExchanges() != null) && (((TScope)((BPELElementImpl)this.getActivity()).getModel()).getMessageExchanges().getMessageExchange().size() > 0)) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In scope => [BPEL engine restriction] Sorry, but the messageExchanges are not supported for the moment"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In scope => [BPEL engine restriction] Sorry, but the messageExchanges are not supported for the moment")));
		}
		
		
		if( (((TScope)((BPELElementImpl)this.getActivity()).getModel()).getEventHandlers() != null) &&
				((((TScope)((BPELElementImpl)this.getActivity()).getModel()).getEventHandlers().getOnEvent().size() > 0) ||
				(((TScope)((BPELElementImpl)this.getActivity()).getModel()).getEventHandlers().getOnAlarm().size() > 0))) {
			StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.getActivity(), "In scope => [BPEL engine restriction] Sorry, but the eventHandler are not supported for the moment"));
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.getActivity(), new BPELException("In scope => [BPEL engine restriction] Sorry, but the eventHandler are not supported for the moment")));
		}
	}

	

}
