/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.Property;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ToValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class ToValidatorImpl implements ToValidator {

	private static Logger log = Logger.getLogger(ToValidatorImpl.class.getName());

	private To to = null;

	public ToValidatorImpl(final To from) {
		this.to = from;
	}

	public void validate() {

		// validation
		log.finest("validate to");

		// verify if exist
		BPELVariable var = null;
		if(((TTo)((BPELElementImpl)this.to).getModel()).getVariable() != null) {
			var = ScopeImpl.findVariableRecursively(new QName(((TTo)((BPELElementImpl)this.to).getModel()).getVariable()), (BPELElement) ((BPELElementImpl)this.to).getParent());
			if(var == null) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.to, new BPELException("In to => Impossible to find variable corresponding to the name: " + ((TTo)((BPELElementImpl)this.to).getModel()).getVariable())));
			} 		
		}

		final BPELProcess process = ScopeImpl.getProcess(this.to);
		if(((TTo)((BPELElementImpl)this.to).getModel()).getPart() != null) {
			if(var != null) {
				final MessageImpl msg = process.getImports().getMessage(var.getMessageType());
				final Part part = msg.getPart(new QName(var.getMessageType().getNamespaceURI(), ((TTo)((BPELElementImpl)this.to).getModel()).getPart()));
				if(part == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.to, new BPELException("In to => Impossible to find part corresponding to the name: " + ((TTo)((BPELElementImpl)this.to).getModel()).getPart())));
				}
			}
		}

		// find partnerLink
		if(((TTo)((BPELElementImpl)this.to).getModel()).getPartnerLink() != null) {
			final PartnerLink partnerLink = ScopeImpl.findPartnerLinkRecursively(((TTo)((BPELElementImpl)this.to).getModel()).getPartnerLink(), (BPELElement) ((BPELElementImpl)this.to).getParent());
			if(partnerLink == null) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.to, new BPELException("In to => Impossible to find partnerLink corresponding to the name: " + ((TTo)((BPELElementImpl)this.to).getModel()).getPartnerLink())));
			}
		}

		try {
			if(((TTo)((BPELElementImpl)this.to).getModel()).getProperty() != null) {
				final Property prop = process.getImports().getProperty(((TTo)((BPELElementImpl)this.to).getModel()).getProperty());
				if(prop == null) {
					StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.to, new BPELException("In to => Impossible to find property corresponding to this name " + ((TTo)((BPELElementImpl)this.to).getModel()).getProperty())));
				}
			}
		} catch (final WSDL4BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.to, new BPELException("In to => " + e.getMessage(),e)));
		}
		
		if((((TTo)((BPELElementImpl)this.to).getModel()).getExpressionLanguage() != null) && !((TTo)((BPELElementImpl)this.to).getModel()).getExpressionLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")
				&& !((TTo)((BPELElementImpl)this.to).getModel()).getExpressionLanguage().toString().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.to, new BPELException("In expressionLanguage => Unknowned uri: " + ((TTo)((BPELElementImpl)this.to).getModel()).getExpressionLanguage() + ". Only the uri " + "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0" + " and " + "http://www.w3.org/TR/1999/REC-xpath-19991116"+ " are supported")));
		}
	}


}
