/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELDurationExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDurationExpr;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


public class BPELDurationExpressionImpl extends BPELElementImpl<TDurationExpr> implements BPELDurationExpression {



	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(BPELDurationExpressionImpl.class.getName());

	private final BPELProcess bpeldefinition;


	public BPELDurationExpressionImpl(final TDurationExpr model,
			final BPELElement parent) {
		super(Constants._For_QNAME, model, parent);
		this.bpeldefinition = ScopeImpl.getProcess(parent);
	}

	public URI getExpressionLanguage() {
		URI res = null;
		if((this.model != null) && (this.model.getExpressionLanguage() != null)) {
			res = URI.create(this.model.getExpressionLanguage());
		} 
		return res;
	}

	public void setExpressionLanguage(final URI language) {
		this.model.setExpressionLanguage(language.toString());
	}

	public String getContent() {
		String content = null;
		if((this.model.getContent() != null) && (this.model.getContent().size() > 0)) {
			content = this.model.getContent().get(0).toString();
		}
		return content;
	}

	public void setContent(final String arg0) {
		throw new NotImplementedException();
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public Long evaluate(final Scope scope) throws CoreException {
		Long time = null;
		String durationExpression = "";


		if(this.getContent() != null) {
			durationExpression = this.getContent();
		}
		try {
			this.log.finest("duration expression to evaluate: " + durationExpression);
			final InputStream input = new ByteArrayInputStream(durationExpression.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(input);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELDurationExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final Object result = n.jjtAccept(v, null);
			if(result instanceof BPELException) {
				throw (BPELException)result;
			} else if(result instanceof org.jdom.Element) {
				final org.jdom.Element elmt = (org.jdom.Element)result; 
				durationExpression = elmt.getText().replace("'", "");
				durationExpression = elmt.getText().replace("\"", "");
				time = DatatypeFactory.newInstance().newDuration(durationExpression).getTimeInMillis(Calendar.getInstance());

			} else {
				throw new BPELException("result unknown");
			}

		} catch (final DatatypeConfigurationException e) {
			throw new BPELException(e);
		} catch (final BPELException e) {
			throw new CoreException("Impossible to evaluate expression: " + durationExpression, e);
		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + durationExpression, e);
		}


		return time;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public Expression<String, Long> copypaste() {
		final BPELDurationExpression exp = new BPELDurationExpressionImpl(this.getModel(), (BPELElement) this.getParent());
		return exp;
	}

}
