/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class BPELExpressionImpl<E> extends BPELElementImpl<TExpression> implements BPELExpression<E> {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	public BPELExpressionImpl(final QName tag, final TExpression model, final BPELElement parent) {
		super(tag, model, parent);
	}

	public String getContent() {
		String def = null;
		if((this.model != null) && (this.model.getContent() != null) && (this.model.getContent().size() > 0)) {
			def = (String) this.model.getContent().get(0);
			for(final Object s: this.model.getContent()) {
				if((s != null) && (s.toString().trim().length() > 0)) {
					def = (String) s;
				}
			}
		}
		return def;
	}

	public void setContent(final String content) {
		if(this.model != null) {
			this.model.getContent().add(0, content);
		}
	}

	public URI getExpressionLanguage() {
		URI res = null;
		if((this.model != null) && (this.model.getExpressionLanguage() != null)) {
			res = URI.create(this.model.getExpressionLanguage());
		}
		return res;
	}

	public void setExpressionLanguage(final URI language) {
		this.model.setExpressionLanguage(language.toString());
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
