/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer;

import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;



public class ExpressionNode extends SimpleNode {

	private String image;
	
	public enum Equality {
		EQUAL("="), DIFFERENT("!=");

		private String value = "";

		/**
		 * Creates a new instance of {@link FeatureConstants}
		 * 
		 * @param value
		 */
		private Equality(final String value) {
			this.value = value;
		}

		/**
		 * 
		 * @return
		 */
		public String value() {
			return this.value;
		}

		/**
		 * Please use this equals method instead of using :<code>
         * value().equals(value)
         * </code> which is
		 * almost 10 times slower...
		 * 
		 * @param value
		 * @return
		 */
		public boolean equals(final String val) {
			return this.value().equals(val);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.lang.Enum#toString()
		 */
		@Override
		public String toString() {
			return this.value;
		}
	}
	
	public enum Inequality {
		INFERIOR("<"), SUPERIOR(">"), INFERIOR_EQUALS("<="), SUPERIOR_EQUALS(">=");

		private String value = "";

		/**
		 * Creates a new instance of {@link FeatureConstants}
		 * 
		 * @param value
		 */
		private Inequality(final String value) {
			this.value = value;
		}

		/**
		 * 
		 * @return
		 */
		public String value() {
			return this.value;
		}

		/**
		 * Please use this equals method instead of using :<code>
         * value().equals(value)
         * </code> which is
		 * almost 10 times slower...
		 * 
		 * @param value
		 * @return
		 */
		public boolean equals(final String val) {
			return this.value().equals(val);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.lang.Enum#toString()
		 */
		@Override
		public String toString() {
			return this.value;
		}
	}
	
	
	public enum Multiplicative {
		MULT("*"), DIV("/"), MOD("%");

		private String value = "";

		/**
		 * Creates a new instance of {@link FeatureConstants}
		 * 
		 * @param value
		 */
		private Multiplicative(final String value) {
			this.value = value;
		}

		/**
		 * 
		 * @return
		 */
		public String value() {
			return this.value;
		}

		/**
		 * Please use this equals method instead of using :<code>
		 * value().equals(value)
		 * </code> which is
		 * almost 10 times slower...
		 * 
		 * @param value
		 * @return
		 */
		public boolean equals(final String val) {
			return this.value().equals(val);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.lang.Enum#toString()
		 */
		@Override
		public String toString() {
			return this.value;
		}
	}


	public ExpressionNode(final int i) {
		super(i);
	}

	public ExpressionNode(final Expression p, final int i) {
		super(p, i);
	}

	public static Node jjtCreate(final int id) {
		return new ExpressionNode(id);
	}

	public static Node jjtCreate(final Expression p, final int id) {
		return new ExpressionNode(p, id);
	}
	
	public void setImage(final String image) {
		this.image = image;
	}
	
	public String getImage() {
		return this.image;
	}
	
	public static Multiplicative getMultiplicative(final String image) {
		Multiplicative res = null;
		if("*".equals(image)) {
			res = Multiplicative.MULT;
		} else if("/".equals(image)) {
			res = Multiplicative.DIV;
		} else if("%".equals(image)) {
			res = Multiplicative.MOD;
		}
		return res;
	}

	public static Inequality getInequality(final String image) {
		Inequality res = null;
		if("<".equals(image)) {
			res = Inequality.INFERIOR;
		} else if("<=".equals(image)) {
			res = Inequality.INFERIOR_EQUALS;
		} else if(">".equals(image)) {
			res = Inequality.SUPERIOR;
		} else if(">=".equals(image)) {
			res = Inequality.SUPERIOR_EQUALS;
		} 
		return res;
	}
	
	public static Equality getEquality(final String image) {
		Equality res = null;
		if("=".equals(image)) {
			res = Equality.EQUAL;
		} else if("!=".equals(image)) {
			res = Equality.DIFFERENT;
		} 
		return res;
	}
	
	public static boolean isPlus(final String image) {
		boolean res = false;
		if(image.equals("+")) {
			res = true;
		}
		return res;
	}
	
	public static boolean isEqual(final String image) {
		boolean res = false;
		if(image.equals("==")) {
			res = true;
		}
		return res;
	}
	
	public static boolean getBoolean(final String image) {
		return Boolean.valueOf(image);
	}
	
	public static String getCharacter(final String image) {
		return image.replaceAll("'", "");
	}
	
	public static Float getFloat(final String image) {
		return Float.parseFloat(image);
	}
	
	public static Integer getInteger(final String image) {
		return Integer.parseInt(image);
	}
	
	public static String getString(final String image) {
		return image.substring(1, image.length()-1);
	}
	
	public static String getAttributeName(final String image) {
		return image.substring(1, image.length());
	}
}

