/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.CodepointsToStringFunction;

/**
 * @author Julien Lesbegueries - eBM WebSourcing
 */
public class CodepointsToStringFunctionImpl extends AbstractXPathFunction<String> implements CodepointsToStringFunction {

	private static Logger log = Logger.getLogger(CodepointsToStringFunctionImpl.class.getName());

	private final List<Integer> _params;	
	
	public CodepointsToStringFunctionImpl(final String ns, final List<Integer> params) throws BPELException {
		super(ns);
		this._params = params;
	}

	public String process() throws BPELException {
		final int[] tmpParams = new int[this._params.size()];
		final Iterator<Integer> it = this._params.iterator();
		int i=0;
		while(it.hasNext()){
			tmpParams[i] = it.next();
			i++;
		}
		final String res = new String(tmpParams, 0, tmpParams.length);
		return res;
	}



}
