/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.EscapeHTMLURIFunction;

/**
 * @author Julien Lesbegueries - eBM WebSourcing
 */
public class EscapeHTMLURIFunctionImpl extends AbstractXPathFunction<String> implements EscapeHTMLURIFunction {

	private static Logger log = Logger.getLogger(EscapeHTMLURIFunctionImpl.class.getName());

	private final String _param;
	
	public EscapeHTMLURIFunctionImpl(final String ns, final String param) throws BPELException {
		super(ns);
		this._param = param;
	}

	public String process() throws BPELException {
		String res = "";
		final char[] toRes = this._param.toCharArray();
		for(final char c : toRes){
			final int ic = new Integer(c).intValue();
			//TODO check if it is the correct range to escape
			if(((ic < 48)  && ((ic != 35) && (ic != 46)))|| ((ic > 57) && (ic < 65)) || ((ic > 90) && (ic < 97))||(ic > 122)){
				res+="%"+Integer.toHexString(ic).toUpperCase();
			}else{
				res+=c;
			}			
		}
		log.finest("RES : "+res);
		return res;
	}



}
