/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function;

import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.function.NormalizeSpaceFunction;


/**
 * @author Julien Lesbegueries - eBM WebSourcing
 */
public class NormalizeSpaceFunctionImpl extends AbstractXPathFunction<String>  implements NormalizeSpaceFunction {

	private static Logger log = Logger.getLogger(NormalizeSpaceFunctionImpl.class.getName());

	private String _string;

	public NormalizeSpaceFunctionImpl(final String ns, final String string) throws BPELException {
		super(ns);
		this._string = string;
	}

	public NormalizeSpaceFunctionImpl(final String ns) throws BPELException {
		super(ns);
		log.severe("function normalize-space() without argument not yet implemented");
		throw new NotImplementedException("function normalize-space() with no argument");
	}

	
	public String process() throws BPELException {
		log.finest("res of normalize-space function: "+this._string.trim());
		return this._string.trim();
	}



}
