/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;
import org.ow2.easywsdl.wsdl.util.Util;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.FromAndTo;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.SelectionFailureException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ASTXpathExpression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ParseException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.JDomAnalyzer;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;

/**
 * @author Adrien Louis - eBM WebSourcing
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELAssigner implements Assigner {

	private Logger log = Logger.getLogger(BPELAssigner.class.getName());

	private final Descriptions desc;

	private final BPELProcess bpeldefinition;

	public BPELAssigner(final BPELProcess bpeldefinition) {
		this.desc = bpeldefinition.getImports();
		this.bpeldefinition = bpeldefinition;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public Expression affect(final Scope scope, final Expression left, final Expression right) throws CoreException {
		Variable v = null;
		try {
			this.log.finest("affect " + right + " in " + left);

			final Element leftSide = null; 
			final Element rightSide = null;

			if(!(left instanceof To)) {
				throw new BPELException("Incorrect affectation !!!");
			}
			if(!(right instanceof From)) {
				throw new BPELException("Incorrect affectation !!!");
			}

			final To to = (To)left;
			final From from = (From)right;

			if((to.getKind() == To.Kind.PARTNERLINK)||(from.getKind() == From.Kind.PARTNERLINK)) {
				v = this.affectPartner(scope, leftSide, rightSide, to, from);
			} else {
				v = this.affectVariable(scope, leftSide, rightSide, to, from);
			}			
		} catch (final BPELException e) {
			throw new CoreException(e);
		} 
		return v;
	}

	private Variable affectPartner(final Scope scope, final Element leftSide,
			Element rightSide, final To to, final From from) throws CoreException {
		Variable v = null;
		try {
			PartnerLink partner = null;
			v = this.findVariable(scope, to);
			if(v == null) {
				// it is not a variable: find partner
				if(to.getKind() == To.Kind.PARTNERLINK) {
					partner = this.findPartner(scope, to.getPartnerLinkVar().getPartnerLink(), this.bpeldefinition);
					if(partner == null) {
						throw new CoreException("Impossible to find the partner: " + to.getPartnerLinkVar().getPartnerLink());
					}
				}
			}

			if((v == null)&&(partner == null)) {
				throw new CoreException("Impossible to find variable or partner");
			}

			// get the epr
			EndpointReferenceType eprFrom = null;
			if(from.getKind() == From.Kind.LITERAL) {
				// find litteral to service ref
				if(from.getLiteral().getElementContent() != null) {
					this.log.finest("litteral content = " + from.getLiteral().getElementContent());
				} else {
					this.log.finest("litteral content = " + from.getLiteral().getStringContent());
				}
				final SAXBuilder builder = new SAXBuilder();
				Element root = null;
				if(from.getLiteral().getElementContent() != null) {
					eprFrom = this.getEpr((Element) ((Element)from.getLiteral().getElementContent().getChildren().get(0)).detach());
				} else if(from.getLiteral().getStringContent() != null) {
					final Document doc = builder.build(new ByteArrayInputStream(from.getLiteral().getStringContent().getBytes()));
					root = (Element) ((Element) doc.getRootElement().getChildren().get(0)).clone();
					eprFrom = this.getEpr(root);
				} else {
					eprFrom = WSAddressingFactory.getInstance().newEndpointReferenceType();
				}
			} else if((from.getKind() == From.Kind.EXPRESSION)||(from.getKind() == From.Kind.VARIABLE_PART)) {
				final ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(new ByteArrayInputStream("".getBytes()));
				// find variable to service ref
				String expression = "";
				if(from.getKind() == From.Kind.EXPRESSION) {
					expression = from.getContent();
				} else if(from.getKind() == From.Kind.VARIABLE_PART) {
					expression = BPELAssigner.convertVariable2Expression(from.getVariablePart());
				}
				expression = expression.trim();

				// get the value or element to affect
				this.log.finest("expression from  = " + expression);
				expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
				final ASTStart n = expressionAnalyzer.Start();
				final ExpressionVisitor ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
				if(!this.log.getName().equals(BPELAssigner.class.getName())) {
					((ExpressionDumpVisitor)ev).setLog(this.log);
				}
				rightSide = n.jjtAccept(ev, null);

				if(rightSide == null) {
					throw new BPELException("Impossible to find right side element from expression: " + expression);
				}

				this.log.finest("rightSide = " + rightSide);
				if(rightSide.getChildren().size() > 0) {
					eprFrom = this.getEpr((Element) ((Element) rightSide.getChildren().get(0)).clone());
				} else {
					eprFrom = WSAddressingFactory.getInstance().newEndpointReferenceType();
				}
			} else if(from.getKind() == From.Kind.PARTNERLINK) {
				// find partner to epr
				final PartnerLink partnerFrom = this.findPartner(scope, from.getPartnerLinkVar().getPartnerLink(), this.bpeldefinition);
				if(partnerFrom == null) {
					throw new CoreException("Impossible to find the partner");
				}
				final Endpoint ep = scope.getEndpoints().get(partnerFrom);
				if(ep == null) {
					throw new CoreException("Impossible to find the endpoint");
				}
				eprFrom = WSAddressingFactory.getInstance().newEndpointReferenceType();
				eprFrom.setAddress(ep.getEndpointName());
			} 

			if(eprFrom == null) {
				throw new BPELException("Impossible to find epr in part from");
			}

			final org.ow2.easywsdl.wsdl.api.Endpoint defEp = this.bpeldefinition.getImports().findEndpoint(eprFrom.getAddress().trim());


			// affect epr
			EndpointReferenceType eprTo = null;
			if(v != null) {
				if(v.getValue().getContent() != null) {
					eprTo = this.getEpr((Element) v.getValue().getContent());
				} else {
					eprTo = WSAddressingFactory.getInstance().newEndpointReferenceType();
				}

				if(defEp != null) {
					eprTo.setAddress(defEp.getAddress());
				} else {
					eprTo.setAddress(eprFrom.getAddress().trim());
				}

				final String eprToBuffer = WSAddressingFactory.getInstance().newWSAddressingWriter().writeEndpointReferenceType(eprTo);
				if(v.getValue().getContent() != null) {
					((Element) v.getValue().getContent()).removeContent();
					final JDomAnalyzer jdomAnalyzer = new JDomAnalyzer(new InputSource(new ByteArrayInputStream(eprToBuffer.getBytes())));
					((Element) v.getValue().getContent()).getChildren().add(jdomAnalyzer.getDocument().clone());
				} else {
					final Element serviceRef = new Element("service-ref", Namespace.getNamespace("s-ref", "http://docs.oasis-open.org/wsbpel/2.0/serviceref")) ;
					final Document doc = new Document();
					doc.setRootElement(serviceRef);
					final JDomAnalyzer jdomAnalyzer = new JDomAnalyzer(new InputSource(new ByteArrayInputStream(eprToBuffer.getBytes())));
					serviceRef.getChildren().add(jdomAnalyzer.getDocument().clone());

					v.getValue().setContent(serviceRef);
				}
			} else if(partner != null) {
				// find endpoint of partner
				final Endpoint ep = scope.findEndpoint(partner);

				if(eprFrom.getAddress() != null) {
					if(defEp != null) {
						ep.setEndpointName(defEp.getName());
						ep.setServiceName(defEp.getService().getQName());
						ep.setAddress(defEp.getAddress());
					} else {
						ep.setAddress(eprFrom.getAddress().trim());
					}

				} else {
					ep.setEndpointName(null);
					ep.setServiceName(null);
					ep.setAddress(null);
				}
				this.log.finest("endpoint of partner " + partner.getName() + " set at : " + ep.getEndpointName() );
			}

		} catch (final IOException e) {
			throw new CoreException(e);
		} catch (final JDOMException e) {
			throw new CoreException(e);
		} catch (final WSAddressingException e) {
			throw new CoreException(e);
		} catch (final BPELException e) {
			throw new CoreException(e);
		} catch (final ParseException e) {
			throw new CoreException(e);
		}
		return v;
	}

	private EndpointReferenceType getEpr(final Element root) throws CoreException {
		EndpointReferenceType epr = null;
		try {
			final Document eprjDom = new Document((Element) root.clone());
			final DOMOutputter converter = new DOMOutputter();
			final org.w3c.dom.Document eprDom = converter.output(eprjDom);
			epr = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(eprDom);
		} catch (final JDOMException e) {
			throw new CoreException(e);
		} catch (final WSAddressingException e) {
			throw new CoreException(e);
		}
		return epr;
	}

	private PartnerLink findPartner(final Scope scope, final String partnerLink, final BPELProcess bpeldefinition) throws CoreException {
		final PartnerLink partner = null;
		final Scope current = scope;
		final PartnerLink pl = bpeldefinition.getPartnerLink(partnerLink);
		return pl;
	}

	private Variable affectVariable(final Scope scope, Element leftSide,
			Element rightSide, final To to, final From from) throws 
			BPELException {
		Variable v = null;
		try {
			v = this.findVariable(scope, to);

			// create variable message if not exist
			BPELInternalMessageImpl.createMessageIfNotExist(v, this.desc);
			this.log.finest("message created: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)v.getValue().getContent()));

			final ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(new ByteArrayInputStream("".getBytes()));

			// analyse left (to) side
			if((to.getKind() == To.Kind.EXPRESSION)||(to.getKind() == To.Kind.VARIABLE_PART)) {

				String expression = "";
				if(to.getKind() == To.Kind.EXPRESSION) {
					expression = to.getContent().trim();
				} else if(to.getKind() == To.Kind.VARIABLE_PART) {
					expression = BPELAssigner.convertVariable2Expression(to.getVariablePart());
				}

				// get the value or element to affect
				this.log.finest("expression to  = " + expression);
				expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
				ASTStart n = expressionAnalyzer.Start();
				ExpressionVisitor ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
				if(!this.log.getName().equals(BPELAssigner.class.getName())) {
					((ExpressionDumpVisitor)ev).setLog(this.log);
				}

				BPELException ex = null;
				try {
					leftSide = n.jjtAccept(ev, null);
				} catch(final BPELException e) {
					ex = e;
				}

				this.log.finest("leftSide = " + leftSide);
				if((leftSide == null)&&(n.jjtGetChild(0) instanceof ASTXpathExpression)) {
					this.log.finest("leftSide == null => try to add nillable or array element");
					this.addNecessaryMinOccursEqual0ElementOrEmptyArrayElement(expressionAnalyzer, expression, ev);

					expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
					n = expressionAnalyzer.Start();
					ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
					if(!this.log.getName().equals(BPELAssigner.class.getName())) {
						((ExpressionDumpVisitor)ev).setLog(this.log);
					}	
					leftSide = n.jjtAccept(ev, null);

				} 

				if(leftSide == null) {
					SelectionFailureException selectionFailureException = null;
					if(ex != null) {
						selectionFailureException = new SelectionFailureException("Impossible to find element corresponding to " + expression, ex);
					} else {
						selectionFailureException = new SelectionFailureException("Impossible to find element corresponding to " + expression);
					}
					throw selectionFailureException;
				}
				this.log.finest("leftSide = \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(leftSide));

			} else if(to.getKind() == To.Kind.VARIABLE_PART) {
				throw new NotImplementedException("Affectation using variable not implemented: Use affectation by expression");
			} else {
				// TODO: find other kind of leftSide
				throw new NotImplementedException();
			}




			// Analyze right (from) side
			if(from.getKind() == From.Kind.LITERAL) {

				// create literal element
				if(from.getLiteral().getElementContent() != null) {
					rightSide = (Element) from.getLiteral().getElementContent().detach();
				} else if(from.getLiteral().getStringContent() != null) {
					rightSide = new Element("literal");
					final Document doc = new Document(rightSide);
					rightSide.setText(from.getLiteral().getStringContent().trim());
				}
			} else if((from.getKind() == From.Kind.EXPRESSION)||(from.getKind() == From.Kind.VARIABLE_PART)) {

				String expression = "";
				if(from.getKind() == From.Kind.EXPRESSION) {
					expression = from.getContent().trim();
				} else if(from.getKind() == From.Kind.VARIABLE_PART) {
					expression = BPELAssigner.convertVariable2Expression(from.getVariablePart());
				}

				// get the value or element to affect
				this.log.finest("expression from  = " + expression);
				expressionAnalyzer.ReInit(new ByteArrayInputStream(expression.getBytes()));
				final ASTStart n = expressionAnalyzer.Start();
				final ExpressionVisitor ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
				if(!this.log.getName().equals(BPELAssigner.class.getName())) {
					((ExpressionDumpVisitor)ev).setLog(this.log);
				}
				rightSide = n.jjtAccept(ev, null);

				this.log.finest("rightSide = " + rightSide);
				if(rightSide == null) {
					throw new SelectionFailureException("Impossible to find right side element from expression: " + expression);
				}
				this.log.finest("rightSide = \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(rightSide));

			} else if(from.getKind() == From.Kind.VARIABLE_PART) {
				throw new NotImplementedException("Affectation using variable not implemented: Use affectation by expression");
			} else {
				// TODO: find other kind of rigthSide
				throw new NotImplementedException();
			}


			// realize the affectation
			// assigment Must be done in a MUTEX section to avoid parallel read/write
			this.log.finest("Assigment : enter MUTEX section on variables "+leftSide.getName()+" and "+rightSide.getName());
			synchronized(leftSide){
				synchronized(rightSide){

					// 1 - Realize type verification
					//TODO: realize type verification


					// verify if it is an affectation on a attribute or an element
					final Attribute workOnAttribute = leftSide.getAttribute("workOnAttribute", Namespace.getNamespace("meta_ebm", "http://com.ebmwebsourcing.easybpel/metadata"));
					if(workOnAttribute != null) {
						final String attributeName = Util.getLocalPartWithoutPrefix(workOnAttribute.getValue());
						final String prefix = Util.getPrefix(workOnAttribute.getValue());
						Namespace nsAttr = null;
						if((prefix != null) && (prefix.trim().length() > 0)) {
							final String ns = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
							nsAttr = Namespace.getNamespace(prefix, ns) ;
						}

						Attribute leftAttribute = null;
						if(nsAttr != null) {
							leftAttribute = leftSide.getAttribute(attributeName, nsAttr);
						} else {
							leftAttribute = leftSide.getAttribute(attributeName);
						}

						// affect left attribute
						leftAttribute.setValue(this.affectTextElementOrAttributeValueInRightSide(rightSide));

						// remove metadata attribute
						leftSide.removeAttribute(workOnAttribute);


					} else {
						// 2 - remove all child on left side
						leftSide.removeContent();
						leftSide.setText(null);

						// 3 - affect
						if((rightSide.getChildren() != null)&&(rightSide.getChildren().size() > 0)) {
							final Element rightTemp = (Element) ((Element) rightSide.clone()).detach();
							final Iterator<Element> it = rightTemp.getChildren().iterator();
							while(it.hasNext()) {
								final Element child = it.next();
								leftSide.addContent(((Element)child.clone()).detach());
							}
						} else {
							leftSide.setText(this.affectTextElementOrAttributeValueInRightSide(rightSide));
						}
					}
				}
			}
			// end MUTEX SECTION
			this.log.finest("Assigment : exit MUTEX section on variables "+leftSide.getName()+" and "+rightSide.getName());

			// print final message
			this.log.finest("final " + v.getQName() + " variable value: \n" + v.getValue());
		} catch (final ParseException e) {
			throw new BPELException("Impossible to realize the following assignment: " + to + " = " + from, e);
		} catch (final BPELException e) {
			throw new BPELException("Impossible to realize the following assignment: " + to + " = " + from, e);
		} catch (final CoreException e) {
			throw new BPELException("Impossible to realize the following assignment: " + to + " = " + from, e);
		}
		return v;
	}

	private Element addNecessaryMinOccursEqual0ElementOrEmptyArrayElement(
			final ExpressionAnalyzer expressionAnalyzer, final String expression,
			final ExpressionVisitor ev) throws BPELException {
		Element res = null;

		try {
			Element parent = null;
			ASTStart n;
			boolean isArray = false;


			// get parent expression
			if(expression.lastIndexOf("/") > 0) {
				String parentExpression = expression.substring(0, expression.lastIndexOf("/"));


				String childElement = expression.substring(expression.lastIndexOf("/")+1, expression.length());
				String currentExpression = parentExpression;
				while(childElement.startsWith("@")) {
					parentExpression = currentExpression.substring(0, currentExpression.lastIndexOf("/"));
					childElement = currentExpression.substring(currentExpression.lastIndexOf("/")+1, currentExpression.length());
					currentExpression = parentExpression;
				}

				if(childElement.indexOf("[") > 0) {
					childElement = childElement.substring(0, childElement.indexOf("["));
					isArray = true;
				}


				this.log.finest("parent expression = " + parentExpression);
				this.log.finest("childElement = " + childElement);
				expressionAnalyzer.ReInit(new ByteArrayInputStream(parentExpression.getBytes()));
				n = expressionAnalyzer.Start();

				parent = n.jjtAccept(ev, null);

				if(parent == null) {
					parent = this.addNecessaryMinOccursEqual0ElementOrEmptyArrayElement(
							expressionAnalyzer,  parentExpression, ev);
				}

				if(parent == null) {
					throw new BPELException("Impossible to find parent");
				}



				final String prefix = Util.getPrefix(childElement);
				final String localName = Util.getLocalPartWithoutPrefix(childElement);
				String ns = null;
				QName qn = null;
				if(prefix != null) {
					ns = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
					qn = new QName(ns, localName, prefix);
				} else {
					ns = parent.getDocument().getRootElement().getNamespaceURI();
					qn = new QName(ns, localName);
				}



				final List<org.ow2.easywsdl.schema.api.Element> childs = this.bpeldefinition.getImports().findElementsInAllSchema(qn);
				if((childs == null) || (childs.size() == 0)) {
					throw new BPELException("Impossible to find child in all definitions: " + qn);
				}

				if((childs.get(0).getMinOccurs() == 0)||(isArray)) {
					this.log.finest("create optional child or new item of array: " + childs.get(0));
					parent = XSD2XML.newInstance().addMinOccursEqual0OrArrayElement(childs.get(0), parent);
					if(parent.getChildren(childs.get(0).getQName().getLocalPart(), Namespace.getNamespace(childs.get(0).getQName().getNamespaceURI())).size() > 0) {
						res = (Element) parent.getChildren(childs.get(0).getQName().getLocalPart(), Namespace.getNamespace(childs.get(0).getQName().getNamespaceURI())).get(0);
					}
					if((res == null)&&(parent.getChildren(childs.get(0).getQName().getLocalPart()).size() > 0)) {
						res = (Element) parent.getChildren(childs.get(0).getQName().getLocalPart()).get(0);
					}
					if(res == null) {
						res = parent;
					}
				} else {
					this.log.finest("child already created: " + childs.get(0));
					if(parent.getChildren(childs.get(0).getQName().getLocalPart(), Namespace.getNamespace(childs.get(0).getQName().getNamespaceURI())).size() > 0) {
						res = (Element) parent.getChildren(childs.get(0).getQName().getLocalPart(), Namespace.getNamespace(childs.get(0).getQName().getNamespaceURI())).get(0);
					}
					if((res == null)&&(parent.getChildren(childs.get(0).getQName().getLocalPart()).size() > 0)) {
						res = (Element) parent.getChildren(childs.get(0).getQName().getLocalPart()).get(0);
					}
					if(res == null) {
						res = parent;
					}
				}

				this.log.finest("parent expression complet = " + parentExpression);
				this.log.finest("childElement complet = " + childElement);

			} else {
				throw new BPELException("Impossible to find element from expression: " + expression);
			}
		} catch (final ParseException e) {
			throw new BPELException(e);
		} catch (final SchemaException e) {
			throw new BPELException(e);
		}
		return res;
	}

	private String affectTextElementOrAttributeValueInRightSide(
			final Element rightSide) {
		String value = "";
		final Attribute workOnAttribute = rightSide.getAttribute("workOnAttribute", Namespace.getNamespace("meta_ebm", "http://com.ebmwebsourcing.easybpel/metadata"));
		if(workOnAttribute != null) {
			final String attributeName = Util.getLocalPartWithoutPrefix(workOnAttribute.getValue());
			final String prefix = Util.getPrefix(workOnAttribute.getValue());
			Namespace nsAttr = null;
			if((prefix != null) && (prefix.trim().length() > 0)) {
				final String ns = this.bpeldefinition.getNamespaceContext().getNamespaceURI(prefix);
				nsAttr = Namespace.getNamespace(prefix, ns) ;
			}

			Attribute rightAttribute = null;
			if(nsAttr != null) {
				rightAttribute = rightSide.getAttribute(attributeName, nsAttr);
			} else {
				rightAttribute = rightSide.getAttribute(attributeName);
			}

			// remove metadata attribute
			rightSide.removeAttribute(workOnAttribute);

			value = rightAttribute.getValue();
		} else {
			value = rightSide.getText();
		}
		return value;
	}

	private Variable findVariable(final Scope scope, final FromAndTo to) throws CoreException {
		Variable v = null;

		// find variable in scope
		String variableName = null;
		if(to.getKind() != To.Kind.PARTNERLINK) {
			if(to.getKind() == To.Kind.EXPRESSION) {
				variableName = BPELVariableImpl.getVariableNameInXPathExpression(to.getContent());
			} else if(to.getKind() == To.Kind.VARIABLE_PART) {
				variableName = to.getVariablePart().getVariable().getLocalPart();
			}
			variableName = variableName.trim();

			this.log.finest("find variable " + variableName);

			v = scope.findVariable(new QName(Util.getLocalPartWithoutPrefix(variableName)));
			if(v == null) {
				throw new CoreException("Error: impossible to find the variable: " + variableName);
			}
		}
		return v;
	}

	public static String convertVariable2Expression(final VariablePart var) throws BPELException {
		String expression = null;
		if(var != null) {
			expression = "$" + var.getVariable();
			if(var.getPart() != null) {
				expression = expression + "." + var.getPart();
			}
			if(var.getQuery() != null) {
				if(!var.getQuery().getQueryLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")) {
					throw new BPELException("this query language (" + var.getQuery().getQueryLanguage() + ") is not recognized. Only XPATH1.0 language (urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0) is supported" );
				}
				if(var.getQuery().getContent().startsWith("/")) {
					expression = expression + var.getQuery().getContent().trim();
				} else {
					expression = expression + "/" + var.getQuery().getContent().trim();
				}
			}
		}
		return expression.trim();
	}

	public static List<String> createXPathExpressionByReplacingPartByElement(final String partName,
			final BPELVariable definition, String xpathExpression, final BPELProcess bpelDefinition)
			throws BPELException {
		final List<String> xpathExpressions = new ArrayList<String>();


		// remove variable
		String expWithoutVarAndPart = null;
		if(xpathExpression.indexOf("/") > 0) {
			expWithoutVarAndPart = xpathExpression.substring(xpathExpression.indexOf("/"));
		}

		if((expWithoutVarAndPart == null)&&(partName == null)) {
			// get all document
			xpathExpression = "/";
			xpathExpressions.add(xpathExpression);
		} else if(definition.getMessageType() != null) {
			final MessageImpl msg = bpelDefinition.getImports().getMessage(definition.getMessageType());

			if(msg == null) {
				throw new BPELException("Error: the message cannot be null: " + definition.getMessageType());
			}


			final Part part = msg.getPart(new QName(msg.getQName().getNamespaceURI(), partName));

			if(part == null) {
				throw new BPELException("Impossible to find part corresponding to " + partName);
			}

			if(part.getElement() != null) {

				String prefix = bpelDefinition.getNamespaceContext().getPrefix(part.getElement().getQName().getNamespaceURI());
				if(prefix == null) {
					// find ns in all import
					prefix = bpelDefinition.getImports().getNamespaces().getPrefix(part.getElement().getQName().getNamespaceURI());
					if(prefix != null) {
						if(bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, part.getElement().getQName().getNamespaceURI());
						} else {
							// generate new prefix
							int i = 0;
							String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							while(nsAlreadyExist != null) {
								i++;
								nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							}

							prefix = "cns" + i;
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, part.getElement().getQName().getNamespaceURI());
						}
					}
				}

				final String localName = part.getElement().getQName().getLocalPart();
				if(expWithoutVarAndPart == null) {
					expWithoutVarAndPart = "";
				}


				if(prefix != null) {
					final String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validRpcXpathExpression);
				} 
				final String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedRpcXpathExpression);

				if(prefix != null) {
					final String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validDocXpathExpression);
				} 
				final String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedDocXpathExpression);


			} else if(part.getPartQName() != null) {

				String prefix = bpelDefinition.getNamespaceContext().getPrefix(part.getPartQName().getNamespaceURI());
				if(prefix == null) {
					// find ns in all import
					prefix = bpelDefinition.getImports().getNamespaces().getPrefix(part.getType().getQName().getNamespaceURI());
					if(prefix != null) {
						if(bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, part.getType().getQName().getNamespaceURI());
						} else {
							// generate new prefix
							int i = 0;
							String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							while(nsAlreadyExist != null) {
								i++;
								nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							}

							prefix = "cns" + i;
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, part.getType().getQName().getNamespaceURI());
						}
					}
				}

				final String localName = part.getPartQName().getLocalPart();
				if(expWithoutVarAndPart == null) {
					expWithoutVarAndPart = "";
				}

				if(prefix != null) {
					final String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validRpcXpathExpression);
				} 
				final String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedRpcXpathExpression);

				if(prefix != null) {
					final String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validDocXpathExpression);
				} 
				final String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedDocXpathExpression);

			}

		} else if(definition.getTypeQName() != null) {

			// local variable
			// variable correspond to the element
			xpathExpression = xpathExpression.replace("$", "/");
			xpathExpressions.add(xpathExpression);

			// add prefix to element
			xpathExpression = xpathExpression.replaceFirst("/", "/" + definition.getTypeQName().getPrefix() + ":");
			xpathExpressions.add(xpathExpression);
		} else if(definition.getElement() != null) {
			if(expWithoutVarAndPart == null) {
				expWithoutVarAndPart = "";
			}

			// local variable
			// variable correspond to the element
			if(expWithoutVarAndPart == null) {
				expWithoutVarAndPart = "";
			}

			xpathExpression = definition.getElement().getLocalPart() + expWithoutVarAndPart;
			xpathExpressions.add(xpathExpression);

			// local variable
			// variable correspond to the element
			if(expWithoutVarAndPart.trim().length() > 0) {
				xpathExpression = expWithoutVarAndPart.replaceFirst("/", "");
				xpathExpressions.add(xpathExpression);
			}

			// local variable
			// variable correspond to the element
			if(definition.getElement().getPrefix() != null) {
				xpathExpression = definition.getElement().getPrefix() + ":" + definition.getElement().getLocalPart() + expWithoutVarAndPart;
			}
			xpathExpressions.add(xpathExpression);
		}

		return xpathExpressions;
	}


}
