/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Description;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELReader;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription.WSDLVersionConstants;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.XMLConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ImportImpl extends BPELElementImpl<TImport> implements Import {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static WSDL4BPELReader reader4wsdl = null;

	private static SchemaReader reader4schema = null;

	public Description description = null;

	public Schema schema = null;

	//TODO Change URI parameter to URL parameter ?
	public ImportImpl(final TImport model, final BPELElement parent) {
		super(Constants._Import_QNAME, model, parent);

		//TODO Check this code (both the same code) unnecessary ?
		//TODO Manage all protocols (not only local) for the baseURI parameter
		try {
			final BPELProcess process = ScopeImpl.getProcess(this);
			final URI baseUri = process.getDocumentBaseURI();

			if(this.getImportType() != null) {
				if(this.getImportType().toString().equals(WSDLVersionConstants.WSDL11.value().toString())) {
					if(this.getLocation() != null) {
						URL location = null;
						if(baseUri.isAbsolute()) {
							final URI locationUri = new URI(
									baseUri.toURL().getProtocol(), baseUri.toURL().getUserInfo(),
									baseUri.toURL().getHost(), baseUri.toURL().getPort(),
									baseUri.getPath().substring(0,
											baseUri.getPath().lastIndexOf("/") + 1) + this.getLocation().toString(), null, baseUri.toURL().getRef());
							location = locationUri.toURL();
						} else {
							location = (new File(baseUri.normalize().toString()+this.getLocation())).toURI().toURL();
						}
						this.description = ImportImpl.getReader4wsdl().read(location);
					}
				} else if(this.getImportType().toString().equals(WSDLVersionConstants.WSDL20.value().toString())) {
					if(this.getLocation() != null) {
						URL location = null;
						if(baseUri.isAbsolute()) {
							final URI locationUri = new URI(
									baseUri.toURL().getProtocol(), baseUri.toURL().getUserInfo(),
									baseUri.toURL().getHost(), baseUri.toURL().getPort(),
									baseUri.getPath().substring(0,
											baseUri.getPath().lastIndexOf("/") + 1) + this.getLocation().toString(), null, baseUri.toURL().getRef());
							location = locationUri.toURL();
						} else {
							location = (new File(baseUri.normalize().toString()+this.getLocation())).toURI().toURL();
						}
						this.description = ImportImpl.getReader4wsdl().read(location);
					}
				} else if(this.getImportType().toString().equals(XMLConstants.W3C_XML_SCHEMA_NS_URI)) {
					if(this.getLocation() != null) {
						URL location = null;
						if(baseUri.isAbsolute()) {
							final URI locationUri = new URI(
									baseUri.toURL().getProtocol(), baseUri.toURL().getUserInfo(),
									baseUri.toURL().getHost(), baseUri.toURL().getPort(),
									baseUri.getPath().substring(0,
											baseUri.getPath().lastIndexOf("/") + 1) + this.getLocation().toString(), null, baseUri.toURL().getRef());
							location = locationUri.toURL();
						} else {
							location = (new File(baseUri.normalize().toString()+this.getLocation())).toURI().toURL();
						}
						this.schema = ImportImpl.getReader4schema().read(location);
					}
				} 
			}
		} catch (final WSDL4BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		} catch (final SchemaException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		} catch (final URISyntaxException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		} catch (final MalformedURLException e){
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		} catch (final IOException e){
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		}
	}

	public static WSDL4BPELReader getReader4wsdl() throws WSDL4BPELException {
		if(reader4wsdl == null) {
			reader4wsdl = WSDL4BPELFactory.newInstance().newWSDLReader();
		}
		return reader4wsdl;
	}

	public static SchemaReader getReader4schema() throws SchemaException {
		if(reader4schema == null) {
			reader4schema = SchemaFactory.newInstance().newSchemaReader();
		}
		return reader4schema;
	}

	public Description getDescription() {
		return this.description;
	}

	public URI getImportType()  {
		URI res = null;
		if(this.model.getImportType() != null) {
			res = URI.create(this.model.getImportType());
		} 
		return res;
	}

	public URI getLocation() {
		URI res = null;
		if(this.model.getLocation() != null) {
			res = URI.create(this.model.getLocation());
		}
		return res;
	}

	public URI getNamespace() {
		URI res = null;
		if(this.model.getNamespace() != null) {
			res = URI.create(this.model.getNamespace());
		} 		
		return res;
	}

	@Override
	public Schema getSchema() {
		return this.schema;
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new XmlException("Not yet implmented");
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}

}

