/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariables;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationSetImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.FaultHandlersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELVariableImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeImpl
extends ActivityImpl<TScope>
implements Scope {
    private static final long serialVersionUID = 1L;
    private final List<BPELVariable> variables = new ArrayList<BPELVariable>();
    private final List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();
    private final List<CorrelationSet> correlationsets = new ArrayList<CorrelationSet>();
    private FaultHandlers faultHandlers = null;
    private Activity activity;

    public ScopeImpl(TScope tScope, BPELElement bPELElement) {
        super(Constants._Scope_QNAME, tScope, bPELElement);
        if (((TScope)this.model).getPartnerLinks() != null && ((TScope)this.model).getPartnerLinks().getPartnerLink() != null && ((TScope)this.model).getPartnerLinks().getPartnerLink().size() > 0) {
            for (TPartnerLink tPartnerLink : ((TScope)this.model).getPartnerLinks().getPartnerLink()) {
                this.partnerLinks.add(new PartnerLinkImpl(tPartnerLink, ((TScope)this.model).getPartnerLinks(), (BPELElement)this));
            }
        }
        try {
            this.variables.addAll(BPELVariableImpl.extractVariablesInModel(((TScope)this.model).getVariables(), this));
        }
        catch (BPELException bPELException) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + bPELException.getMessage(), (Throwable)((Object)bPELException))));
        }
        try {
            this.correlationsets.addAll(CorrelationSetImpl.extractCorrelationSetsInModel(((TScope)this.model).getCorrelationSets(), this));
        }
        catch (BPELException bPELException) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + bPELException.getMessage(), (Throwable)((Object)bPELException))));
        }
        try {
            this.activity = ActivityImpl.analyzeScope(tScope, this);
        }
        catch (BPELException bPELException) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + bPELException.getMessage(), (Throwable)((Object)bPELException))));
        }
        if (((TScope)this.model).getFaultHandlers() != null) {
            this.faultHandlers = new FaultHandlersImpl(((TScope)this.model).getFaultHandlers(), this);
        }
    }

    @Override
    public void addVariable(BPELVariable bPELVariable) {
        this.variables.add(bPELVariable);
    }

    @Override
    public List<BPELVariable> getVariables() {
        return this.variables;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public PartnerLink getPartnerLink(String string) {
        PartnerLink partnerLink = null;
        for (PartnerLink partnerLink2 : this.partnerLinks) {
            if (!partnerLink2.getName().equals(string)) continue;
            partnerLink = partnerLink2;
            break;
        }
        return partnerLink;
    }

    @Override
    public List<PartnerLink> getPartnerLinks() {
        return this.partnerLinks;
    }

    @Override
    public CorrelationSet getCorrelationSet(String string) {
        CorrelationSet correlationSet = null;
        for (CorrelationSet correlationSet2 : this.correlationsets) {
            if (!correlationSet2.getName().equals(string)) continue;
            correlationSet = correlationSet2;
            break;
        }
        return correlationSet;
    }

    @Override
    public List<CorrelationSet> getCorrelationSets() {
        return this.correlationsets;
    }

    @Override
    public FaultHandlers getFaultHandlers() {
        return this.faultHandlers;
    }

    @Override
    public BPELVariable findVariable(QName qName) {
        BPELVariable bPELVariable = null;
        if (this.variables != null && qName != null) {
            for (BPELVariable bPELVariable2 : this.variables) {
                if (bPELVariable2.getQName() == null || !bPELVariable2.getQName().equals(qName)) continue;
                bPELVariable = bPELVariable2;
                break;
            }
        }
        if (bPELVariable == null) {
            bPELVariable = ScopeImpl.findVariableRecursively(qName, (BPELElement)this.getParent());
        }
        return bPELVariable;
    }

    public static BPELVariable findVariableRecursively(QName qName, BPELElement bPELElement) {
        BPELVariable bPELVariable = null;
        if (qName != null && bPELElement != null) {
            ForEach forEach;
            if (bPELElement instanceof BPELProcess) {
                bPELVariable = ((BPELProcess)bPELElement).findVariable(qName);
            } else if (bPELElement instanceof Scope) {
                bPELVariable = ((Scope)bPELElement).findVariable(qName);
            } else if (bPELElement instanceof ForEach && (forEach = (ForEach)bPELElement).getCounterName().equals(qName.getLocalPart())) {
                TVariable tVariable = new TVariable();
                tVariable.setName(qName.getLocalPart());
                tVariable.setType(DefaultSchemaImpl.getInstance().getTypeInt().getQName());
                TVariables tVariables = new TVariables();
                tVariables.getVariable().add(tVariable);
                BPELIntVariableImpl bPELIntVariableImpl = new BPELIntVariableImpl(tVariable, tVariables, bPELElement);
                bPELVariable = bPELIntVariableImpl;
            }
            if (bPELVariable == null) {
                bPELVariable = ScopeImpl.findVariableRecursively(qName, (BPELElement)((AbstractSchemaElementImpl)bPELElement).getParent());
            }
        }
        return bPELVariable;
    }

    public static PartnerLink findPartnerLinkRecursively(String string, BPELElement bPELElement) {
        PartnerLink partnerLink = null;
        Scope scope = ScopeImpl.getParentScope(bPELElement);
        if (scope != null) {
            partnerLink = scope.findPartnerLink(string);
        }
        if (partnerLink == null) {
            BPELProcess bPELProcess = ScopeImpl.getProcess(bPELElement);
            partnerLink = bPELProcess.findPartnerLink(string);
        }
        return partnerLink;
    }

    public static BPELProcess getProcess(BPELElement bPELElement) {
        BPELProcess bPELProcess = null;
        if (bPELElement != null) {
            bPELProcess = bPELElement instanceof BPELProcess ? (BPELProcess)bPELElement : ScopeImpl.getProcess((BPELElement)((AbstractSchemaElementImpl)bPELElement).getParent());
        }
        return bPELProcess;
    }

    public static Scope getParentScope(BPELElement bPELElement) {
        BPELElement bPELElement2;
        Scope scope = null;
        if (bPELElement != null && (bPELElement2 = (BPELElement)((AbstractSchemaElementImpl)bPELElement).getParent()) != null) {
            scope = bPELElement2 instanceof Scope ? (Scope)bPELElement2 : ScopeImpl.getParentScope(bPELElement2);
        }
        return scope;
    }

    @Override
    public PartnerLink findPartnerLink(String string) {
        PartnerLink partnerLink = null;
        for (PartnerLink partnerLink2 : this.partnerLinks) {
            if (!partnerLink2.getName().equals(string)) continue;
            partnerLink = partnerLink2;
            break;
        }
        return partnerLink;
    }
}

