/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation;

import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Error;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Info;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Warning;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAnalysisPrinter {
    private static StaticAnalysisPrinter instance = null;

    public static StaticAnalysisPrinter getInstance() {
        if (instance == null) {
            instance = new StaticAnalysisPrinter();
        }
        return instance;
    }

    public List<String> printErrorsAsString(List<Error> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Error error : list) {
            arrayList.add(error.getError().getMessage());
        }
        return arrayList;
    }

    public String printAllErrors(List<Error> list) {
        String string = "";
        for (String string2 : this.printErrorsAsString(list)) {
            string = String.valueOf(string) + string2 + "\n";
        }
        return string;
    }

    public String printAllWarnings(List<Warning> list) {
        String string = "";
        for (Warning warning : list) {
            string = String.valueOf(string) + warning.getWarning() + "\n";
        }
        return string;
    }

    public String printAllInfos(List<Info> list) {
        String string = "";
        for (Info info : list) {
            string = String.valueOf(string) + info.getInfo() + "\n";
        }
        return string;
    }

    public String printAll(List<Error> list, List<Warning> list2, List<Info> list3) {
        String string = "";
        if (list3 != null && list3.size() > 0) {
            string = String.valueOf(string) + list3.size() + " Infos:\n" + this.printAllInfos(list3);
        }
        if (string.length() > 0) {
            string = String.valueOf(string) + "\n";
        }
        if (list2 != null && list2.size() > 0) {
            string = String.valueOf(string) + list2.size() + " Warnings:\n" + this.printAllWarnings(list2);
        }
        if (string.length() > 0) {
            string = String.valueOf(string) + "\n";
        }
        if (list != null && list.size() > 0) {
            string = String.valueOf(string) + list.size() + " Errors:\n" + this.printAllErrors(list);
        }
        return string;
    }
}

