/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CorrelationSetValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Property;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;

public class CorrelationSetValidatorImpl
implements CorrelationSetValidator {
    private CorrelationSet correlationSet = null;

    public CorrelationSetValidatorImpl(CorrelationSet correlationSet) {
        this.correlationSet = correlationSet;
    }

    public void validate() {
        try {
            if (this.correlationSet.getName() == null || this.correlationSet.getName().trim().length() == 0) {
                StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => The name cannot be null or empty")));
            }
            if (this.correlationSet.getProperties() == null || this.correlationSet.getProperties().size() == 0) {
                StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => The properties cannot be null or empty")));
            }
            BPELProcess bPELProcess = ScopeImpl.getProcess(this.correlationSet);
            if (this.correlationSet.getProperties() != null) {
                for (QName qName : this.correlationSet.getProperties()) {
                    Property property = bPELProcess.getImports().getProperty(qName);
                    if (property != null) continue;
                    StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => Impossible to find property corresponding to this name " + qName)));
                }
            }
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => " + wSDL4BPELException.getMessage(), wSDL4BPELException)));
        }
    }
}

