/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PartnerLinkValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.InfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.WarningImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.InterfaceType;

public class PartnerLinkValidatorImpl
implements PartnerLinkValidator {
    private PartnerLink partnerLink = null;

    public PartnerLinkValidatorImpl(PartnerLink partnerLink) {
        this.partnerLink = partnerLink;
    }

    public void validate() {
        try {
            if (!(this.partnerLink.getMyRole() != null && this.partnerLink.getMyRole().trim().length() != 0 || this.partnerLink.getPartnerRole() != null && this.partnerLink.getPartnerRole().trim().length() != 0)) {
                StaticAnalysisImpl.getInstance().addWarning(new WarningImpl(this.partnerLink, "In PartnerLink " + this.partnerLink.getName() + " => No defined role: neither myRole or partnerRole"));
            }
            BPELProcess bPELProcess = ScopeImpl.getProcess((BPELElement)((BPELElementImpl)((Object)this.partnerLink)).getParent());
            if (this.partnerLink.getPartnerLinkType() == null || this.partnerLink.getPartnerLinkType().toString().trim().length() == 0) {
                StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => PartnerLinkType cannot be null or empty")));
            } else {
                PartnerLinkType partnerLinkType = bPELProcess.getImports().getPartnerLinkType(this.partnerLink.getPartnerLinkType());
                if (partnerLinkType == null) {
                    StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => Impossible to find in wsdl descriptions the partnerLinkType: " + this.partnerLink.getPartnerLinkType())));
                } else {
                    for (Role role : partnerLinkType.getRoles()) {
                        InterfaceType interfaceType = role.getInterface();
                        if (interfaceType != null) continue;
                        StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.partnerLink, new BPELException("PartnerLinkType Definition Error => Impossible to find in wsdl descriptions the interface : " + role.getInterface() + " corresponding to role " + role.getName())));
                    }
                }
            }
            if (this.partnerLink.getInitializePartnerRole() != null) {
                StaticAnalysisImpl.getInstance().addInfo(new InfoImpl(this.partnerLink, "[BPEL engine Restriction] In PartnerLink " + this.partnerLink.getName() + " => The value of InitializePartnerRole is ignored : default and unique value for moment = true"));
            }
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => " + wSDL4BPELException.getMessage())));
        }
    }
}

