/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.Expression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionTreeConstants;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.analyzer.Node;
import org.jdom.Element;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected Expression parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Expression expression, int n) {
        this(n);
        this.parser = expression;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object object) {
        this.value = object;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Element jjtAccept(ExpressionVisitor expressionVisitor, Element element) throws BPELException {
        return expressionVisitor.visit(this, element);
    }

    public Object childrenAccept(ExpressionVisitor expressionVisitor, Element element) throws BPELException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(expressionVisitor, element);
                ++n;
            }
        }
        return element;
    }

    public String toString() {
        return ExpressionTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return String.valueOf(string) + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(String.valueOf(string) + " ");
                }
                ++n;
            }
        }
    }
}

