/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.registry;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.registry.BPELRegistry;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=BPELRegistry.class)})
@Membrane(controller="primitive")
public class BPELMemoryRegistryImpl
extends AbstractProcessDefinitionRegistry<BPELProcess>
implements BPELRegistry {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(BPELMemoryRegistryImpl.class.getName());
    Map<ProcessKey, BPELProcess> registry = new HashMap<ProcessKey, BPELProcess>();

    public BPELProcess getProcessDefinition(ProcessKey processKey) {
        return this.registry.get(processKey);
    }

    public List<BPELProcess> getAllProcessDefinitions() {
        return new ArrayList<BPELProcess>(this.registry.values());
    }

    public BPELProcess removeProcessDefinition(ProcessKey processKey, boolean bl) throws CoreException {
        Object object;
        BPELProcess bPELProcess = null;
        this.log.finest("Map of instance: " + ((MemoryProcessInstanceRegistryImpl)this.getModel().getCore().getEngine().getProcessInstanceRegistry()).getMap());
        Iterator iterator = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(processKey).iterator();
        ArrayList<Process> arrayList = new ArrayList<Process>();
        while (iterator.hasNext()) {
            Process process;
            object = (Process)iterator.next();
            if (bl) {
                this.log.finest("remove process instance: " + object.getName());
                process = this.getModel().getCore().getEngine().getProcessInstanceRegistry().removeProcessInstance(object, bl);
                if (process != null) {
                    iterator = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(processKey).iterator();
                    continue;
                }
                this.log.warning("Impossible to delete instance: " + object.getName());
                continue;
            }
            if (object.getParentExecution() != null && object.getParentExecution().getState() == Execution.State.ENDED || object.getParentExecution() == null) {
                this.log.finest("remove process instance: " + object.getName());
                process = this.getModel().getCore().getEngine().getProcessInstanceRegistry().removeProcessInstance(object, bl);
                if (process != null) {
                    iterator = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(processKey).iterator();
                    continue;
                }
                this.log.warning("Impossible to delete instance: " + object.getName());
                continue;
            }
            if (arrayList.contains(object)) continue;
            arrayList.add((Process)object);
        }
        if (arrayList.size() > 0) {
            object = "";
            for (Process process : arrayList) {
                object = String.valueOf(object) + "Impossible to remove this process instance" + process.getName() + " because it is not ended: state = " + process.getParentExecution().getState() + "\n";
            }
            throw new CoreException((String)object);
        }
        bPELProcess = this.registry.remove(processKey);
        return bPELProcess;
    }

    public synchronized void storeProcessDefinition(URI uRI, ProcessContextDefinition processContextDefinition) throws CoreException {
        Object object;
        BPELProcess bPELProcess = null;
        bPELProcess = (BPELProcess)this.getModel().getCompiler().validate(uRI);
        if (StaticAnalysisImpl.getInstance().getErrors().size() > 0) {
            String string = StaticAnalysisPrinter.getInstance().printAll(StaticAnalysisImpl.getInstance().getErrors(), StaticAnalysisImpl.getInstance().getWarnings(), StaticAnalysisImpl.getInstance().getInfos());
            throw new CoreException("Compilation Error: " + string);
        }
        if (StaticAnalysisImpl.getInstance().getWarnings().size() > 0) {
            object = StaticAnalysisPrinter.getInstance().printAll(StaticAnalysisImpl.getInstance().getErrors(), StaticAnalysisImpl.getInstance().getWarnings(), StaticAnalysisImpl.getInstance().getInfos());
            this.log.finest("Compilation warning: " + (String)object);
        }
        object = null;
        try {
            object = this.createKeys(bPELProcess);
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            throw new CoreException((Throwable)wSDL4BPELException);
        }
        if (object == null || object.size() == 0) {
            throw new CoreException("The keys cannot be null");
        }
        String string = "\nList of key :\n";
        Process process = object.iterator();
        while (process.hasNext()) {
            ProcessKey processKey = (ProcessKey)process.next();
            string = String.valueOf(string) + processKey.toString();
            this.registry.put(processKey, bPELProcess);
        }
        int n = 0;
        while (n < processContextDefinition.getPoolSize()) {
            ++n;
            process = this.getModel().getCompiler().compile((ProcessDefinition)bPELProcess);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ProcessKey processKey = (ProcessKey)iterator.next();
                this.getModel().getCore().getEngine().getProcessInstanceRegistry().storeProcessInstance(processKey, process);
            }
            process.run();
        }
        this.log.finest(string);
    }

    public void unStoreProcessDefinition(URI uRI, boolean bl) throws CoreException {
        BPELProcess bPELProcess = null;
        bPELProcess = (BPELProcess)this.getModel().getCompiler().validate(uRI);
        List<ProcessKey> list = null;
        try {
            list = this.createKeys(bPELProcess);
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            throw new CoreException((Throwable)wSDL4BPELException);
        }
        if (list != null) {
            for (ProcessKey processKey : list) {
                this.removeProcessDefinition(processKey, bl);
            }
        }
    }

    private List<ProcessKey> createKeys(BPELProcess bPELProcess) throws WSDL4BPELException {
        ArrayList<ProcessKey> arrayList = new ArrayList<ProcessKey>();
        List<AbsItfInterfaceType> list = bPELProcess.getImports().getProcessInterfaces();
        for (AbsItfInterfaceType absItfInterfaceType : list) {
            if (absItfInterfaceType != null) {
                List list2 = bPELProcess.getImports().findEndpointsImplementingInterface((AbsItfInterfaceType)((InterfaceType)absItfInterfaceType));
                if (list2 != null && list2.size() >= 1) {
                    for (Endpoint endpoint : list2) {
                        if (endpoint.getService() == null) continue;
                        arrayList.add((ProcessKey)new ProcessKeyImpl(absItfInterfaceType.getQName(), ((Service)endpoint.getService()).getQName(), endpoint.getName()));
                    }
                    continue;
                }
                arrayList.add((ProcessKey)new ProcessKeyImpl(absItfInterfaceType.getQName(), null, null));
                continue;
            }
            arrayList.add((ProcessKey)new ProcessKeyImpl(bPELProcess.getQName(), null, null));
        }
        return arrayList;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

