/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

public class XPathAnalyzer {
    private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());

    public Element evaluate(String string, Element element, NamespaceMapperImpl namespaceMapperImpl) throws BPELException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.evaluate(arrayList, element, namespaceMapperImpl);
    }

    public Element evaluate(List<String> list, Element element, NamespaceMapperImpl namespaceMapperImpl) throws BPELException {
        Element element2 = null;
        try {
            for (String string : list) {
                XPath xPath = XPath.newInstance((String)string);
                Object object = namespaceMapperImpl.getNamespaces().entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = object.next();
                    xPath.addNamespace((String)entry.getKey(), (String)entry.getValue());
                }
                if (element.getDocument() == null) {
                    new Document(element);
                }
                if ((object = xPath.selectSingleNode((Object)element)) instanceof Document) {
                    element2 = ((Document)object).getRootElement();
                    log.finest("this xpath expression " + string + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(element));
                    break;
                }
                if (!(object instanceof Element)) continue;
                element2 = (Element)object;
                log.finest("this xpath expression " + string + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(element));
                break;
            }
            if (element2 == null) {
                log.finest("namespace used: " + namespaceMapperImpl.getNamespaces());
                log.finest("No xpath expressions " + list + " match with: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(element));
            }
        }
        catch (JDOMException jDOMException) {
            throw new BPELException((Throwable)jDOMException);
        }
        return element2;
    }
}

