/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.ConcatFunction;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ConcatFunctionImpl extends AbstractXPathFunction<String> implements ConcatFunction {

	private static Logger log = Logger.getLogger(ConcatFunctionImpl.class.getName());

	private final List<String> params;

	public ConcatFunctionImpl(final String ns, final List<String> params) throws XPathExpressionException {
		super(ns);
		this.params = params;
	}

	public String process() throws XPathExpressionException {
		String res = "";
		for(final String param: this.params) {
			res = res + param;
		}
		return res;
	}



}
