/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.AbstractXPathFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.api.function.SubstringFunction;

/**
 * @author Julien Lesbegueries - eBM WebSourcing
 */
public class SubstringFunctionImpl extends AbstractXPathFunction<String>  implements SubstringFunction {

	private static Logger log = Logger
			.getLogger(SubstringFunctionImpl.class.getName());

	private final String _oriString;
	private final int _start;
	private final int _length;

	public SubstringFunctionImpl(final String ns, final String oriString, final int start, final int length) throws XPathExpressionException {
		super(ns);
		this._oriString = oriString;
		this._length = length;
		this._start = start;
		log.finest("Parameters for function Substring : "+oriString+" "+start+" "+length);
	}

	public SubstringFunctionImpl(final String ns, final String oriString, final int start) throws XPathExpressionException {
		super(ns);
		this._oriString = oriString;
		this._start = start;
		this._length = this._oriString.length()-this._start+1;
		log.finest("Parameters for function Substring : "+oriString+" "+start);
	}

	
	public String process() throws XPathExpressionException {
		final String res = this._oriString.substring(this._start-1, this._start-1+this._length);
		log.finest("Result of function Substring : "+res);
		return res;
	}
	
}
