/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.verification;

import java.util.Date;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.jdom.Element;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.verification.TypeVerifier;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public class TypeVerifier2Impl implements TypeVerifier {

    public TypeVerifier2Impl() {
    }


    public Class<?> compare(final Element e1, final Element e2)
            throws XPathExpressionException {
        Class<?> res = null;
        if ((this.isInteger(e1) && (this.isInteger(e2)))) {
            res = Integer.class;
        } else if (this.isInteger(e1) && (this.isLong(e2))) {
            res = Long.class;
        } else if (this.isInteger(e1) && (this.isDouble(e2))) {
            res = Double.class;
        } else if (this.isLong(e1) && (this.isInteger(e2))) {
            res = Long.class;
        } else if (this.isDouble(e1) && (this.isInteger(e2))) {
            res = Double.class;
        } else if (this.isLong(e1) && (this.isLong(e2))) {
            res = Long.class;
        } else if (this.isLong(e1) && (this.isDouble(e2))) {
            res = Double.class;
        } else if (this.isDouble(e1) && (this.isLong(e2))) {
            res = Double.class;
        } else if (this.isDouble(e1) && (this.isDouble(e2))) {
            res = Double.class;
        } else if ((this.isBoolean(e1) && (this.isBoolean(e2)))) {
            res = Boolean.class;
        } else if ((this.isDateTime(e1) && (this.isDateTime(e2)))) {
            res = Date.class;
        } else if ((this.isString(e1) && (this.isString(e2)))) {
            res = String.class;
        }
        return res;
    }

    public boolean isInteger(final Element e) throws XPathExpressionException {
        try {
            Integer.parseInt(e.getTextNormalize());
        } catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isLong(final Element e) throws XPathExpressionException {
        try {
            Long.parseLong(e.getTextNormalize());
        } catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isDouble(final Element e) throws XPathExpressionException {
        try {
            Integer.parseInt(e.getTextNormalize());
        } catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isDateTime(final Element e) throws XPathExpressionException {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        XMLGregorianCalendar xmlCalendar;
        try {
            xmlCalendar = DatatypeFactory.newInstance()
                    .newXMLGregorianCalendar(e.getText());
            xmlCalendar.toGregorianCalendar().getTime();
            return true;
        } catch (Exception ex) {
            return false;
        }
    }

    public boolean isString(final Element e) throws XPathExpressionException {
        boolean res = !e.getTextNormalize().isEmpty();
        return res;
    }

    public boolean isBoolean(final Element e) throws XPathExpressionException {
        try {
            return Boolean.parseBoolean(e.getTextNormalize().toLowerCase());
        } catch (NumberFormatException nfe) {
        }
        try {
            boolean res = Integer.parseInt(e.getTextNormalize()) == 1;
            return res;
        } catch (NumberFormatException nfe) {
        }
        return false;
    }

    public int getIntValue(final Element e) {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        return Integer.parseInt(s);
    }

    public long getLongValue(final Element e) {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        return Long.parseLong(s);
    }

    public double getDoubleValue(final Element e) {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        return Double.parseDouble(s);
    }

    public String getStringValue(final Element e) {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        return s;
    }

    public boolean getBooleanValue(final Element e) {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        try {
            return Boolean.parseBoolean(e.getTextNormalize().toLowerCase());
        } catch (NumberFormatException nfe) {
        }
        return Integer.parseInt(e.getTextNormalize()) == 1;
    }

    public Date getDateTimeValue(final Element e) {
        String s = e.getTextNormalize();
        assert !s.isEmpty();
        XMLGregorianCalendar xmlCalendar;
        try {
            xmlCalendar = DatatypeFactory.newInstance()
                    .newXMLGregorianCalendar(e.getText());
            return xmlCalendar.toGregorianCalendar().getTime();
        } catch (DatatypeConfigurationException e1) {
            throw new UncheckedException(e1);
        }
    }

}
