/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.Expression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionTreeConstants;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.Node;
import org.jdom.Element;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected Expression parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Expression expression, int n) {
        this(n);
        this.parser = expression;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object object) {
        this.value = object;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    @Override
    public Element jjtAccept(ExpressionVisitor expressionVisitor, Element element) throws XPathExpressionException {
        return expressionVisitor.visit(this, element);
    }

    public Object childrenAccept(ExpressionVisitor expressionVisitor, Element element) throws XPathExpressionException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(expressionVisitor, element);
            }
        }
        return element;
    }

    public String toString() {
        return ExpressionTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }
}

