/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyplnk20.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easyplnk20.api.Constants;

// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "easyplnk20-impl";
    }

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/easyplnk20";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "easyplnk20.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.ObjectFactory.class
                .getPackage();
    }

    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.PLNK20_NS_URI;
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.PLNK20_NS_PREFERRED_PREFIX;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();

        // elements
        factorableClasses.add(PartnerLinkTypeImpl.class);
        factorableClasses.add(RoleImpl.class);

        // types
        factorableClasses.add(TRoleImpl.class);
        factorableClasses.add(TPartnerLinkTypeImpl.class);

        // anonymous types
        factorableClasses.add(DocumentationImpl.class);

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject modelObject) throws InstantiationException,
            IllegalAccessException, InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, modelObject);
    }

}
