/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyplnk20.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyplnk20.api.anonymoustype.Documentation;
import com.ebmwebsourcing.easyplnk20.api.type.TExtensibleElements;

import easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.EJaxbDocumentation;
import easybox.org.oasis_open.docs.wsbpel._2_0.plnktype.EJaxbTExtensibleElements;

abstract class AbstractTExtensibleElementsImpl<Model extends EJaxbTExtensibleElements>
        extends AbstractJaxbXmlObjectImpl<Model> implements TExtensibleElements {

    protected AbstractTExtensibleElementsImpl(XmlContext xmlContext,
            Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public final void addAnyXmlObject(XmlObject anyXmlObject) {
        addToAny(getModelObject().getAny(), anyXmlObject);
    }

    @Override
    public final void clearAnyXmlObjects() {
        clearChildren(getModelObject().getAny(), Object.class,
                AbstractJaxbXmlObjectImpl.ANY_QNAME);
    }

    @Override
    public final <X extends XmlObject> X getFirstAnyXmlObject(
            Class<X> interfaceClass) {
        X[] children = getAnyXmlObjects(interfaceClass);
        if (children.length == 0)
            return null;
        return children[0];
    }

    @Override
    public final XmlObject[] getAnyXmlObjects() {
        XmlObject[] anyXmlObjects = createChildrenArray(getModelObject()
                .getAny(), Object.class, AbstractJaxbXmlObjectImpl.ANY_QNAME);
        return anyXmlObjects;
    }

    @SuppressWarnings("unchecked")
    @Override
    public final <X extends XmlObject> X[] getAnyXmlObjects(
            Class<X> interfaceClass) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!interfaceClass.isInstance(anyXmlObject))
                continue;
            result.add(anyXmlObject);
        }
        return (X[]) result.toArray(new XmlObject[result.size()]);
    }

    @Override
    public final XmlObject[] getAnyXmlObjects(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!qname.equals(anyXmlObject.getXmlObjectQName()))
                continue;
            result.add(anyXmlObject);
        }
        return (XmlObject[]) result.toArray(new XmlObject[result.size()]);
    }

    @Override
    public final boolean hasAnyXmlObject(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (qname.equals(anyXmlObject.getXmlObjectQName()))
                return true;
        }
        return false;
    }

    @Override
    public final void removeAnyXmlObject(XmlObject anyXmlObject) {
        removeFromChildren(getModelObject().getAny(), anyXmlObject);
    }

    
    
    @Override
    public final void addOtherAttribute(QName qname, String value) {
        getModelObject().getOtherAttributes().put(qname, value);
    }

    @Override
    public final void clearOtherAttributes() {
        getModelObject().getOtherAttributes().clear();
    }


    @Override
    public final String getOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().get(qname);
    }

    @Override
    public final Map<QName, String> getOtherAttributes() {
        return new HashMap<QName, String>(getModelObject().getOtherAttributes());
    }

    @Override
    public final boolean hasOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().containsKey(qname);
    }

    @Override
    public final void removeOtherAttribute(QName qname) {
        getModelObject().getOtherAttributes().remove(qname);
    }


    @Override
    public Documentation[] getDocumentations() {
        return createChildrenArray(getModelObject().getDocumentation(),
                EJaxbDocumentation.class, ANY_QNAME, Documentation.class);
    }

    @Override
    public void addDocumentation(Documentation documentation) {
        addToChildren(getModelObject().getDocumentation(), documentation);        
    }

    @Override
    public void removeDocumentation(Documentation documentation) {
        removeFromChildren(getModelObject().getDocumentation(), documentation);

    }

    @Override
    public void clearDocumentations() {
        clearChildren(getModelObject().getDocumentation(),
                EJaxbDocumentation.class, ANY_QNAME);

    }

    
}
