/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBContext;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationException;



/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ExtendedActivityConfigurationJAXBContext {

	private static final List<Class> DEFAULTOBJECTFACTORIES = new ArrayList<Class>(Arrays.asList(new Class[] {
			easybpel.ebmwebsourcing.com.extendedactivityconfiguration.ObjectFactory.class}));


	public static List<Class> getDefaultObjectFactories() {
		return DEFAULTOBJECTFACTORIES;
	}

	/**
     * The JAXB context
     */
    private static ExtendedActivityConfigurationJAXBContext instance = null;
    private static ExtendedActivityConfigurationException fail = null;
    
    static {
    	
    	try {
			instance = new ExtendedActivityConfigurationJAXBContext();
		} catch (ExtendedActivityConfigurationException e) {
			fail = e;
		}
    }

	/**
	 * Private object initializations
	 */
	private ExtendedActivityConfigurationJAXBContext() throws ExtendedActivityConfigurationException {
		try {
			SchemaJAXBContext.getInstance().addOtherObjectFactory(DEFAULTOBJECTFACTORIES);
	    	SchemaJAXBContext.getInstance().getJaxbContext();
		} catch (final SchemaException e) {
			throw new ExtendedActivityConfigurationException(e);
		}

	}


	public static ExtendedActivityConfigurationJAXBContext getInstance() throws ExtendedActivityConfigurationException {
		if(fail == null) {
			return instance;
		} else {
			throw fail;
		}
	}



	/**
	 * @return the jaxbContext
	 * @throws Exception 
	 */
	public JAXBContext getJaxbContext() throws ExtendedActivityConfigurationException {
		try {
			return SchemaJAXBContext.getInstance().getJaxbContext();
		} catch (SchemaException e) {
			throw new ExtendedActivityConfigurationException(e);
		}
	}
}
