/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.extended.activities._package.debug.impl;

import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.BreakpointActivity;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.Constants;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.DebugActivity;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.DebugPackageExtendedActivityImpl;
import com.ebmwebsourcing.easybpel.extension.activities._package.debug.TDebugActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.DebugBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.DebugBehaviourImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = BreakpointActivity.class))
public class DebugActivityImpl extends DebugPackageExtendedActivityImpl<TDebugActivity> implements DebugActivity {


	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(DebugActivityImpl.class
			.getName());
	
	public DebugActivityImpl(TDebugActivity model, ExtensionActivity parent)  throws BPELException  {
		super(Constants._Breakpoint_QNAME, model, parent);
	}
	
	public DebugActivityImpl(Element elmt, ExtensionActivity parent) throws BPELException {
		super(Constants._Breakpoint_QNAME, elmt, parent);
	}

	public Node generate(Scope scope) throws CoreException {
		DebugBehaviour debug = new DebugBehaviourImpl();
		debug.setActivate(this.isActivate());
		Node behaviourNode = scope.createNode(this.model.getName(), debug);
		return behaviourNode;
	}


	public void validate(BPELStaticAnalysis analyzer) {
		
	}

	public boolean isActivate() {
		return this.model.isActivate();
	}

	public void setActivate(boolean activate) {
		this.model.setActivate(activate);
	}

	@Override
	protected TDebugActivity convertElementToModel(Element elmt)
			throws BPELException {
		TDebugActivity res = null;
		try {
			JAXBElement<TDebugActivity> jaxb = this.getJaxbContext().createUnmarshaller().unmarshal(elmt, TDebugActivity.class);
			res = jaxb.getValue();
		} catch (JAXBException e) {
			throw new BPELException(e);
		} catch(SchemaException e){
			throw new BPELException(e);
		}
		return res;
	}




}