/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.extended.activities._package.debug.impl;

import java.net.URI;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.BreakpointActivity;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.Constants;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.DebugPackageExtendedActivityImpl;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.EchoActivity;
import com.ebmwebsourcing.easybpel.extension.activities._package.debug.TEchoActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELStringExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELStringExpressionImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.EchoBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.EchoBehaviourImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = BreakpointActivity.class))
public class EchoActivityImpl extends DebugPackageExtendedActivityImpl<TEchoActivity> implements EchoActivity {


	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(EchoActivityImpl.class
			.getName());
	
	private BPELStringExpression exp = null;
	
	public EchoActivityImpl(TEchoActivity model, ExtensionActivity parent) throws BPELException {
		super(Constants._Breakpoint_QNAME, model, parent);
		TExpression exp = new TExpression();
		exp.setExpressionLanguage(this.model.getMessage().getExpressionLanguage());
		exp.getContent().addAll(this.model.getMessage().getContent());
		try {
			this.exp = new BPELStringExpressionImpl(exp, this);
		} catch (XPathExpressionException e) {
			throw new BPELException(e);
		}
	}
	
	public EchoActivityImpl(Element elmt, ExtensionActivity parent) throws BPELException {
		super(Constants._Breakpoint_QNAME, elmt, parent);
		TExpression exp = new TExpression();
		exp.setExpressionLanguage(this.model.getMessage().getExpressionLanguage());
		exp.getContent().addAll(this.model.getMessage().getContent());
		try {
			this.exp = new BPELStringExpressionImpl(exp, this);
		} catch (XPathExpressionException e) {
			throw new BPELException(e);
		}
	}


	public Node generate(Scope scope) throws CoreException {
		EchoBehaviour echoBehaviour = new EchoBehaviourImpl();
		echoBehaviour.setMessage(this.exp);
		Node echoNode = scope.createNode(this.model.getName(), echoBehaviour);
		return echoNode;
	}

	public void validate(BPELStaticAnalysis analyzer) {
		
	}


	public BPELStringExpression getExpression() {
		return this.exp;
	}

	public void setExpression(BPELStringExpression exp) {
		this.exp = exp;
		if(this.model.getMessage() == null) {
			this.model.setMessage(new com.ebmwebsourcing.easybpel.model.bpel.executable.light.TExpression());
		}
		this.model.getMessage().setExpressionLanguage(this.exp.getExpressionLanguage().toString());
		this.model.getMessage().getContent().clear();
		this.model.getMessage().getContent().add(this.exp.getContent());
	}

	@Override
	protected TEchoActivity convertElementToModel(Element elmt)
			throws BPELException {
		TEchoActivity res = null;
		try {
			JAXBElement<TEchoActivity> jaxb = this.getJaxbContext().createUnmarshaller().unmarshal(elmt, TEchoActivity.class);
			res = jaxb.getValue();
		} catch (JAXBException e) {
			throw new BPELException(e);
		} catch (SchemaException e) {
			throw new BPELException(e);
		}
		return res;
	}




}