/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.extended.activities._package.debug.impl;

import java.util.Calendar;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.Constants;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.DebugPackageExtendedActivityImpl;
import com.ebmwebsourcing.easybpel.extended.activities._package.debug.api.LoggerActivity;
import com.ebmwebsourcing.easybpel.extension.activities._package.debug.TLoggerActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELStringExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELStringExpressionImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.LoggerBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.LoggerBehaviourImpl;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = LoggerActivity.class))
public class LoggerActivityImpl extends DebugPackageExtendedActivityImpl<TLoggerActivity> implements LoggerActivity {


	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(LoggerActivityImpl.class
			.getName());
	
	private LoggerBehaviour.LEVEL level;
	
	public LoggerActivityImpl(TLoggerActivity model, ExtensionActivity parent) throws BPELException {
		super(Constants._Breakpoint_QNAME, model, parent);
	}
	
	public LoggerActivityImpl(Element elmt, ExtensionActivity parent) throws BPELException {
		super(Constants._Breakpoint_QNAME, elmt, parent);
	}


	public Node generate(Scope scope) throws CoreException {
		LoggerBehaviour loggerBehaviour = new LoggerBehaviourImpl();
		TExpression expression = new TExpression();
		expression.getContent().add(this.getMessage());
		BPELStringExpression msg = new BPELStringExpressionImpl(expression, this);
		loggerBehaviour.setMessage(msg);

		
		loggerBehaviour.setLevel(LoggerBehaviour.LEVEL.valueOf(this.getLevel()));
		
		Node loggerNode = scope.createNode(this.model.getName(), loggerBehaviour);
		return loggerNode;
	}

	public void validate(BPELStaticAnalysis analyzer) {
		
	}


	public String getMessage() {
		return this.model.getMessage();
	}

	public void setMessage(String message) {
		this.model.setMessage(this.level+" "+Calendar.getInstance().getTime().toString()+" "+message);
	}

	@Override
	protected TLoggerActivity convertElementToModel(Element elmt)
			throws BPELException {
		TLoggerActivity res = null;
		try {
			JAXBElement<TLoggerActivity> jaxb = this.getJaxbContext().createUnmarshaller().unmarshal(elmt, TLoggerActivity.class);
			res = jaxb.getValue();
		} catch (JAXBException e) {
			throw new BPELException(e);
		} catch (SchemaException e) {
			throw new BPELException(e);
		}
		return res;
	}

	
	
	public String getLevel(){
		return this.model.getLevel();
	}
	
	public void setLevel(LoggerBehaviour.LEVEL level){
		this.level = level;
		this.model.setLevel(level.toString());
		this.log.finest(level+"::"+this.model.getLevel());
	}

	
	
}