/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.extended.activities._package.debug.api;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.extension.activities._package.debug.TExtentedActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.AbstractExtendedActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.SourcesImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.TargetsImpl;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCondition;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSources;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTargets;



/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class DebugPackageExtendedActivityImpl<E extends TExtentedActivity> extends AbstractExtendedActivityImpl<E> implements Activity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	

	//	private static Logger log = Logger.getLogger(DebugPackageExtendedActivityImpl.class.getName());

	@SuppressWarnings("unchecked")
	public DebugPackageExtendedActivityImpl(final QName name, final E model, final ExtensionActivity parent) throws BPELException {
		super(name, model, parent);
		copySourcesAndTargets(model);
	}

	public DebugPackageExtendedActivityImpl(QName tag, Element elmt,
			ExtensionActivity parent) throws BPELException {
		super(tag, elmt, parent);
		copySourcesAndTargets(model);
	}

	private void copySourcesAndTargets(final E model) {
		if(model != null) {
			if(this.model.getSources() != null) {
				TSources sources = new TSources();
				sources.getOtherAttributes().putAll(this.model.getSources().getOtherAttributes());
				sources.getSource().addAll((List)this.model.getSources().getSource());
				sources.getAny().addAll(this.model.getSources().getAny());
				this.sources = new SourcesImpl(sources, this);
			}
			if(this.model.getTargets() != null) {
				TTargets targets = new TTargets();
				targets.getOtherAttributes().putAll(this.model.getTargets().getOtherAttributes());
				targets.getTarget().addAll((List)this.model.getTargets().getTarget());
				targets.getAny().addAll(this.model.getTargets().getAny());

				TCondition condition = new TCondition();
				condition.getContent().addAll(this.model.getTargets().getJoinCondition().getContent());
				condition.setExpressionLanguage(this.model.getTargets().getJoinCondition().getExpressionLanguage());
				condition.getOtherAttributes().putAll(this.model.getTargets().getJoinCondition().getOtherAttributes());
				targets.setJoinCondition(condition);
				this.targets = new TargetsImpl(targets, this);
			}
		}
	}







	public boolean getSuppressJoinFailure() {
		return Boolean.valueOf(this.model.getSuppressJoinFailure().value());
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(String name) {
		this.model.setName(name);
	}
	
	
	public void loadJaxbContext() throws BPELException {
	       try {
	    	   List<Class> list = new ArrayList<Class>();
	    	   list.add(com.ebmwebsourcing.easybpel.extension.activities._package.debug.ObjectFactory.class);
	           SchemaJAXBContext.getInstance().addOtherObjectFactory(list);
	           this.jaxbContext = SchemaJAXBContext.getInstance().getJaxbContext();
	                      //this.jaxbContext =  JAXBContext.newInstance(new Class[]{com.ebmwebsourcing.easybpel.extension.activities._package.debug.ObjectFactory.class});
	       } catch (final SchemaException e) {
	           throw new BPELException(e);
	       }
	   } 
	
	
}
